% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{mm}
\alias{mm}
\title{All-in-one wrapper for the conversion between (R) Markdown, FreeMind mind map, Mermaid mind map, R code, directory structure, and HTML widget.}
\usage{
mm(
  from = NA,
  input_type = c("auto", "markdown", "mindmap", "R", "dir"),
  output_type = c("widget", "mindmap", "markdown", "R", "dir", "mermaid"),
  root = NA,
  md_list = FALSE,
  md_eq = FALSE,
  md_braces = FALSE,
  md_bookdown = FALSE,
  md_maxlevel = "",
  r_seclabel = " --------",
  r_chunkheading = FALSE,
  dir_files = TRUE,
  dir_all = TRUE,
  dir_excluded = NA,
  dir_to = NA,
  dir_quiet = FALSE,
  mmd_shape = c("cloud", "rounded_square", "square", "bang", "circle", "hexagon"),
  widget_name = NA,
  widget_width = NULL,
  widget_height = NULL,
  widget_elementId = NULL,
  widget_options = markmapOption(preset = "colorful")
)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{input_type}{Character. The type of the input text. It can be \code{'auto', 'markdown', 'mindmap', 'R', 'dir'}. The default value is \code{'auto'}, which means the type will be automatically assigned according to the features of the input text.}

\item{output_type}{Character. The type of the output. It can be \code{'widget', 'mindmap', 'markdown', 'R', 'dir', 'mmd'}. The default value is \code{'widget'}.}

\item{root}{Character. The string displayed as the root (center) of the mind map.}

\item{md_list}{Logical. whether to process lists like headings in the Markdown input.}

\item{md_eq}{Logical. Whether to include LaTeX equations in the Markdown input when converted to other formats.}

\item{md_braces}{Logical. Whether to remove \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{#ID}} in the headings of the markdown file (usually in a \href{https://github.com/rstudio/bookdown}{bookdown}> project.}

\item{md_bookdown}{Logical. Whether the R Markdown syntax text is in bookdown style, i.e. \code{# (PART), # (APPENDIX)}, and \code{# References} as an upper level of the Level 1 heading.}

\item{md_maxlevel}{Integer or ''. The maximum level of the markdown headings that are displayed in the mind map.}

\item{r_seclabel}{Character. The ending characters indicating sections in R Markdown.}

\item{r_chunkheading}{Logical. Whether process the chunk label as headings.}

\item{dir_files}{Logical. Whether to include files. If \code{FALSE}, only folders are included. If \code{TRUE}, folders and files are included.}

\item{dir_all}{Logical. Whether to include all files in a directory. If \code{FALSE}, only the names of visible files are included (following Unix-style visibility, that is files whose name does not start with a dot). If \code{TRUE}, all file names will be included.}

\item{dir_excluded}{Character. The directories which are not included in the output.}

\item{dir_to}{Character. The path of the output directory.}

\item{dir_quiet}{Logical. Whether to display the results of generated directories.}

\item{mmd_shape}{Character. The shape of mermaid mindmap nodes. See \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{Mermaid document}}.}

\item{widget_name}{Character. The name of the html widget.}

\item{widget_width}{Numeric. The width of the widget.}

\item{widget_height}{Numeric. The height of the widget.}

\item{widget_elementId}{Character. The ID of teh Widget.}

\item{widget_options}{List. Options for the markmap widget. It should be a list passed from the \code{markmapOption()} function.}
}
\value{
Desired output.
}
\description{
All-in-one wrapper for the conversion between (R) Markdown, FreeMind mind map, Mermaid mind map, R code, directory structure, and HTML widget.
}
\details{
\code{mm()} converts between (R) Markdown syntax text, R code, FreeMind mind map code, Mermaid mind map code, and directory, and display them in a HTML widget. It is a wrapper for other conversion functions in this package.
}
\examples{
input <- system.file('examples/mindr-md.Rmd', package = 'mindr')
input_txt <- readLines(input, encoding = 'UTF-8')
mm_output <- mm(input_txt, output_type = c('mindmap', 'markdown', 'R', 'widget'))
mm_output
# See the vignette for more examples:
vignette('mindr', package = 'mindr')
}
