% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{launch_local}
\alias{launch_local}
\alias{launch_remote}
\title{Launch Daemons}
\usage{
launch_local(n = 1L, ..., .compute = NULL)

launch_remote(n = 1L, remote = remote_config(), ..., .compute = NULL)
}
\arguments{
\item{n}{(integer) number of daemons to launch. For \code{launch_remote()}, may
also be a 'miraiCluster' or 'miraiNode'.}

\item{...}{(daemon arguments) passed to \code{\link[=daemon]{daemon()}}, including \code{asyncdial},
\code{autoexit}, \code{cleanup}, \code{output}, \code{maxtasks}, \code{idletime}, and \code{walltime}.
Overrides arguments from \code{\link[=daemons]{daemons()}} if supplied.}

\item{.compute}{(character) name of the compute profile. Each profile has its
own independent set of daemons. \code{NULL} (default) uses the 'default'
profile.}

\item{remote}{(configuration) for launching daemons, generated by
\code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}}, \code{\link[=http_config]{http_config()}}, or \code{\link[=remote_config]{remote_config()}}.
An empty \code{\link[=remote_config]{remote_config()}} returns shell commands for manual deployment
without launching.}
}
\value{
For \strong{launch_local}: Integer number of daemons launched.

For \strong{launch_remote}: A character vector of daemon launch commands,
classed as 'miraiLaunchCmd'. The printed output may be copy / pasted
directly to the remote machine. For the \code{\link[=http_config]{http_config()}} launcher, a list
of server response data, returned invisibly.
}
\description{
\code{launch_local()} launches daemons on the local machine as background R
processes that connect back to the host.

\code{launch_remote} returns the shell command for deploying daemons as a
character vector. If an \code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}} or
\code{\link[=remote_config]{remote_config()}} configuration is supplied then this is used to launch the
daemon on the remote machine.
}
\details{
Daemons must already be set for launchers to work.

These functions may be used to re-launch daemons that have exited after
reaching time or task limits.

For non-dispatcher daemons using the default seed strategy, the generated
command contains the argument \code{rs} specifying the length 7 L'Ecuyer-CMRG
random seed supplied to the daemon. The values will be different each time
the function is called.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(url = host_url(), dispatcher = FALSE)
info()
launch_local(1L, cleanup = FALSE)
launch_remote(1L, cleanup = FALSE)
Sys.sleep(1)
info()
daemons(0)

daemons(url = host_url(tls = TRUE))
info()
launch_local(2L, output = TRUE)
Sys.sleep(1)
info()
daemons(0)
\dontshow{\}) # examplesIf}
}
