% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-index.R
\name{gintervals.convert_to_indexed}
\alias{gintervals.convert_to_indexed}
\title{Convert 1D interval set to indexed format}
\usage{
gintervals.convert_to_indexed(
  set.name = NULL,
  remove.old = FALSE,
  force = FALSE
)
}
\arguments{
\item{set.name}{name of interval set to convert}

\item{remove.old}{if TRUE, removes old per-chromosome files after successful conversion}

\item{force}{if TRUE, re-converts even if already in indexed format}
}
\value{
invisible NULL
}
\description{
Converts a per-chromosome interval set to indexed format
(intervals.dat + intervals.idx) which reduces file descriptor usage.
}
\details{
The indexed format stores all chromosomes in a single intervals.dat file
with an intervals.idx index file. This reduces file descriptor usage from
N files (one per chromosome) to just 2 files.

The conversion process:
\enumerate{
  \item Creates temporary intervals.dat.tmp and intervals.idx.tmp files
  \item Concatenates all per-chromosome files into intervals.dat.tmp
  \item Builds index with offsets and checksums
  \item Atomically renames temporary files to final names
  \item Optionally removes old per-chromosome files
}

The indexed format is 100% backward compatible with all existing misha functions.
}
\examples{
\dontrun{
# Convert an interval set
gintervals.convert_to_indexed("my_intervals")

# Convert and remove old files
gintervals.convert_to_indexed("my_intervals", remove.old = TRUE)

# Force re-conversion
gintervals.convert_to_indexed("my_intervals", force = TRUE)
}
}
\seealso{
\code{\link{gintervals.save}}, \code{\link{gintervals.load}}
}
