% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-modify.R
\name{gtrack.modify}
\alias{gtrack.modify}
\title{Modifies track contents}
\usage{
gtrack.modify(track = NULL, expr = NULL, intervals = NULL)
}
\arguments{
\item{track}{track name}

\item{expr}{track expression}

\item{intervals}{genomic scope for which track is modified}
}
\value{
None.
}
\description{
Modifies 'Dense' track contents.
}
\details{
This function modifies the contents of a 'Dense' track by the values of
'expr'. 'intervals' argument controls which portion of the track is
modified. The iterator policy is set internally to the bin size of the
track.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals(1, 300, 800)
gextract("dense_track", intervs)
gtrack.modify("dense_track", "dense_track * 2", intervs)
gextract("dense_track", intervs)
gtrack.modify("dense_track", "dense_track / 2", intervs)

}
\seealso{
\code{\link{gtrack.create}}, \code{\link{gtrack.rm}}
}
\keyword{~modify}
\keyword{~track}
