% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-var.R
\name{gtrack.var.ls}
\alias{gtrack.var.ls}
\title{Returns a list of track variables for a track}
\usage{
gtrack.var.ls(
  track = NULL,
  pattern = "",
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{track}{track name}

\item{pattern, ignore.case, perl, fixed, useBytes}{see 'grep'}
}
\value{
An array that contains the names of track variables.
}
\description{
Returns a list of track variables for a track.
}
\details{
This function returns a list of track variables of a track that match the
pattern (see 'grep'). If called without any arguments all track variables of
a track are returned.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.var.ls("sparse_track")
gtrack.var.set("sparse_track", "test_var1", 1:10)
gtrack.var.set("sparse_track", "test_var2", "v")
gtrack.var.ls("sparse_track")
gtrack.var.ls("sparse_track", pattern = "2")
gtrack.var.rm("sparse_track", "test_var1")
gtrack.var.rm("sparse_track", "test_var2")

}
\seealso{
\code{\link{grep}}, \code{\link{gtrack.var.get}},
\code{\link{gtrack.var.set}}, \code{\link{gtrack.var.rm}}
}
\keyword{~ls}
\keyword{~variable}
