create_isolated_test_db()
test_that("gextract iterators", {
    expect_regression(gextract("test.fixedbin", gintervals(c(1, 2), 0, 1000000)), "gextract.65")
    expect_regression(gextract("test.sparse", gintervals(c(1, 2), 0, 1000000)), "gextract.64")
    expect_regression(gextract("test.array", gintervals(c(1, 2), 0, 1000000)), "gextract.63")
    expect_regression(gextract("test.rects", gintervals.2d(c(2, 3), 10000000, 50000000, c(2, 4), 30000000, 80000000)), "gextract.62")
    expect_error(gextract("test.rects", intervals = gintervals.2d(c(1), c(0, 50), c(100, 200), c(3), c(0, 50), c(400, 600))))
    expect_error(gextract("test.rects", .misha$ALLGENOME, iterator = gintervals.2d(c(1), c(0, 50), c(100, 200), c(3), c(0, 50), c(400, 600))))
    expect_regression(gextract("test.rects_big_rects", gintervals.2d(c(1:20)), band = c(-1874356, 234560)), "gextract.59")
    expect_regression(gextract("test.computed2d", gintervals.2d(c(6, 8), 10000000, 50000000, c(1, 3), 30000000, 80000000)), "gextract.58")
    expect_error(gextract("test.computed2d", intervals = gintervals.2d(c(1), c(0, 50), c(100, 200), c(3), c(0, 50), c(400, 600))))
    expect_error(gextract("test.computed2d", .misha$ALLGENOME, iterator = gintervals.2d(c(1), c(0, 50), c(100, 200), c(3), c(0, 50), c(400, 600))))
    expect_regression(gextract("test.computed2d", gintervals.2d(c(1:20)), band = c(-1874356, 234560)), "gextract.55")
    expect_regression(gextract("2 * test.fixedbin + 17", gintervals(c(1, 2), 0, 1000000)), "gextract.54")
    expect_regression(gextract("2 * test.sparse + 17", gintervals(c(1, 2), 0, 1000000)), "gextract.53")
    expect_regression(gextract("2 * test.array + 17", gintervals(c(1, 2), 0, 1000000)), "gextract.52")
    expect_regression(gextract("2 * test.rects + 17", gintervals.2d(c(2, 3), 10000000, 50000000, c(2, 4), 30000000, 80000000)), "gextract.51")
    expect_regression(gextract("2 * test.computed2d + 17", gintervals.2d(c(6, 8), 10000000, 50000000, c(1, 3), 30000000, 80000000)), "gextract.50")
    expect_error(gextract("2 * test.fixedbin + 17 > 10", gintervals(c(1, 2), 0, 1000000)))
    expect_error(gextract("test.fixedbin", "test.sparse", gintervals(c(1, 2), 0, 1000000)))
    expect_regression(gextract("test.fixedbin", "test.sparse", gintervals(c(1, 2), 0, 1000000), iterator = "test.fixedbin"), "gextract.47")
    expect_error(gextract("test.fixedbin", "test.array", gintervals(c(1, 2), 0, 1000000)))
    expect_regression(gextract("test.fixedbin", "test.array", gintervals(c(1, 2), 0, 1000000), iterator = "test.fixedbin"), "gextract.45")
    expect_regression(gextract("test.rects", "test.rects * 3", gintervals.2d(c(2, 3), 10000000, 50000000, c(2, 4), 30000000, 80000000), iterator = "test.rects"), "gextract.44")
    expect_regression(gextract("test.computed2d", "test.computed2d * 3", gintervals.2d(c(6, 5), 10000000, 50000000, c(8, 9), 30000000, 80000000), iterator = "test.computed2d"), "gextract.43")
    expect_regression(gextract("test.rects", "test.rects * 3", gintervals.2d(c(6, 5), 10000000, 50000000, c(8, 9), 30000000, 80000000), iterator = "test.computed2d"), "gextract.42")
    expect_regression(gextract("test.computed2d", "test.computed2d * 3", gintervals.2d(c(6, 5), 10000000, 50000000, c(8, 9), 30000000, 80000000), iterator = "test.rects"), "gextract.41")
    expect_regression(gextract("test.fixedbin", gintervals(c(2, 3))), "gextract.40")
    expect_regression(gextract("test.sparse", gintervals(c(2, 3))), "gextract.39")
    expect_regression(gextract("test.array", gintervals(c(2, 3))), "gextract.38")
    expect_regression(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4))), "gextract.37")
    expect_regression(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9))), "gextract.36")
    expect_regression(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = 120), "gextract.35")
    expect_regression(gextract("test.sparse", gintervals(c(2, 3)), iterator = 120), "gextract.34")
    expect_regression(gextract("test.array", gintervals(c(2, 3)), iterator = 120), "gextract.33")
    expect_error(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = 120))
    expect_error(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = 120))
    expect_error(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = c(100000, 100000)))
    expect_error(gextract("test.sparse", gintervals(c(2, 3)), iterator = c(100000, 100000)))
    expect_error(gextract("test.array", gintervals(c(2, 3)), iterator = c(100000, 100000)))
    expect_regression(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = c(100000, 100000)), "gextract.27")
    expect_regression(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = c(100000, 100000)), "gextract.26")
    expect_regression(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = "test.fixedbin"), "gextract.25")
    expect_regression(gextract("test.sparse", gintervals(c(2, 3)), iterator = "test.fixedbin"), "gextract.24")
    expect_regression(gextract("test.array", gintervals(c(2, 3)), iterator = "test.fixedbin"), "gextract.23")
    expect_error(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = "test.fixedbin"))
    expect_error(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.fixedbin"))
    expect_regression(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = "test.sparse"), "gextract.20")
    expect_regression(gextract("test.sparse", gintervals(c(2, 3)), iterator = "test.sparse"), "gextract.19")
    expect_regression(gextract("test.array", gintervals(c(2, 3)), iterator = "test.sparse"), "gextract.18")
    expect_error(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = "test.sparse"))
    expect_error(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.sparse"))
    expect_regression(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = "test.array"), "gextract.15")
    expect_regression(gextract("test.sparse", gintervals(c(2, 3)), iterator = "test.array"), "gextract.14")
    expect_regression(gextract("test.array", gintervals(c(2, 3)), iterator = "test.array"), "gextract.13")
    expect_error(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = "test.array"))
    expect_error(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.array"))
    expect_error(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = "test.rects"))
    expect_error(gextract("test.sparse", gintervals(c(2, 3)), iterator = "test.rects"))
    expect_error(gextract("test.array", gintervals(c(2, 3)), iterator = "test.rects"))
    expect_regression(gextract("test.rects", gintervals.2d(chroms1 = c(2, 3), chroms2 = c(2, 4)), iterator = "test.rects"), "gextract.7")
    expect_regression(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.rects"), "gextract.6")
    expect_error(gextract("test.fixedbin", gintervals(c(2, 3)), iterator = "test.computed2d"))
    expect_error(gextract("test.sparse", gintervals(c(2, 3)), iterator = "test.computed2d"))
    expect_error(gextract("test.array", gintervals(c(2, 3)), iterator = "test.computed2d"))
    expect_regression(gextract("test.rects", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.computed2d"), "gextract.2")
    expect_regression(gextract("test.computed2d", gintervals.2d(chroms1 = c(6, 5), chroms2 = c(8, 9)), iterator = "test.computed2d"), "gextract.1")
})
