\name{fnoise}
\alias{fnoise}
\alias{fdist_stdnorm}
\alias{fdist_stdt}
\alias{fn_stdt}
\alias{b_show}
\alias{distlist}
\alias{ed_nparam}
\alias{ed_parse}
\alias{ed_skeleton}
\alias{ed_src}
\alias{ed_stdnorm}
\alias{ed_stdt}
\alias{ed_stdt0}
\alias{ed_stdt1}
\alias{ft_stdt}

\title{Generator functions for noise distributions}
\description{
  These functions and objects are mostly internal and should not be
  needed for routine use. Generate noise distribution, currently
  standard normal and standardised t-distributions. These functions can
  be used as templates for new distributions.
}
\usage{
fdist_stdnorm()

fdist_stdt(df, fixed = TRUE)

fn_stdt(df, fixed = TRUE)

b_show(x)

distlist(type, param, ncomp = NULL, fixed = FALSE, tr = NULL, \dots)

ed_nparam

ed_parse(s)

ed_skeleton(df, fixed = FALSE, n = length(df), tr = NULL)

ed_src

ed_stdnorm

ed_stdt

ed_stdt0

ed_stdt1

ft_stdt
}
\arguments{
  \item{df}{degrees of freedom}
  \item{fixed}{if TRUE, the parameters are fixed, otherwise they are
    variable, see Details.}
  \item{x}{a fitted object.}% ~~ TODO: describe this argument.
  \item{type}{list of distributions.}
  \item{param}{parameters.}
  \item{ncomp}{number of components.}
  \item{tr}{transformation.}
  \item{...}{not used.}
  \item{s}{named vector.}
  \item{n}{number of different degrees of freedom.}
}
\details{
  If argument \code{fixed} is TRUE, estimation functions assume that the
  parameter(s) are fixed, otherwise they estimate it. The support is
  incomplete, see below.

  \code{fdist_stdnorm} is for the standard normal distribution. For
  example \code{dist_norm} is generated by it.

  \code{fdist_stdt} is for the t-distribution with \code{df} degrees of
  freedom.

  \code{fn_stdt} is also for the t-distribution but the degrees of
  freedom, \code{df}, may be a vector. The value is a list of
  distributions. Although the list can be obtained by repeated calls of
  \code{fdist_stdt} %  ... (todo: unfinished sentence!)

  The support is incomplete.  In particular, if parameter \code{fixed}
  is TRUE, changes to the parameter(s) should probably not be allowed
  (this can be achieved by simply dropping the corresponding function
  from the list). However, a thorough rethinking is necessary, as I
  introduced it on the fly while developing estimation functions and
  forbidding changes may necessitate changes in the code. Changes are
  useful for estimation for convenience but also to avoid recreating the
  whole distributions again and again.

  However, there is a major drawback, which in the final version needs
  to be addressed satisfactorily. Since parameters are held in local
  environments, changes to the parameters are reflected in copies of the
  objects. For example, an estimation function (or the user) may call
  another function with a model containing an object generated by the
  above functions and assign the result to a new object. However if the
  parameters of the noise distribution are changed in the process this
  will be reflected in the original model.

  Note that the above effect is valid only if an object generated by the
  above functions is reused. Objects created by different calls have
  different environments, so the problem does not arise for them.

}
\examples{
stdt3 <- fdist_stdt(3)
stdt3v <- fdist_stdt(3, fixed = FALSE)
fn_stdt(c(20, 30, 40), fixed = FALSE)

mo_tf <- new("MixARgen", prob = exampleModels$WL_ibm@prob,
             scale = exampleModels$WL_ibm@scale, arcoef = exampleModels$WL_ibm@arcoef@a,
             dist = list(generator = function(par)
                 fn_stdt(par, fixed = FALSE), param = c(20, 30, 40)))
mo_tf
str(mo_tf)

noise_dist(mo_tf, "pdf")
parameters(mo_tf)
parameters(mo_tf, names = TRUE)
get_edist(mo_tf)
noise_params(mo_tf)
}
\keyword{MixAR}
