% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedbiastest-package.R
\docType{package}
\name{mixedbiastest-package}
\alias{mixedbiastest-package}
\title{mixedbiastest: Bias Diagnostics for Linear Mixed Models}
\description{
The `mixedbiastest` package provides a function to perform bias diagnostics on linear mixed models fitted with `lmer` from the `lme4` package. It implements permutation tests for assessing the bias of fixed effects, as described in Karl and Zimmerman (2021).
}
\details{
The methods in this package are designed for Gaussian linear mixed models with
diagonal random-effects covariance matrices and homoskedastic residual errors
with covariance \eqn{\sigma^2 I_n}. Models with more general random-effects
structures or residual covariance patterns are currently not supported.


While the bias diagnostic of Karl and Zimmerman (2021) is derived for general
linear mixed models with arbitrary random-effects and residual covariance
matrices \eqn{G} and \eqn{R}, the current \pkg{mixedbiastest} implementation
focuses on the practically important case described above. Extending the
package to handle correlated random effects or more general residual
covariance structures would require additional work on both the underlying
linear algebra and the permutation scheme, and is therefore left for future
research.
}
\section{Functions}{

\describe{
  \item{\code{\link{mixedbiastest}}}{Performs the bias diagnostic test.}
  \item{\code{\link{print.mixedbiastest}}}{Prints the results of the bias diagnostic.}
  \item{\code{\link{plot.mixedbiastest}}}{Plots the permutation distributions and observed test statistics for each fixed effect.}
  \item{\code{\link{list_fixed_effects}}}{ List Fixed Effects from an merMod Object.}
}
}

\section{Acknowledgments}{

Development of this package was assisted by GPT o1-preview and GPT 5 Pro, which helped in constructing the structure of much of the code and the roxygen documentation. The code is based on the R code provided by Karl and Zimmerman (2020).
}

\references{
Karl, A. T., & Zimmerman, D. L. (2021). A diagnostic for bias in linear mixed model estimators induced by dependence between the random effects and the corresponding model matrix. \emph{Journal of Statistical Planning and Inference}, \emph{212}, 70–80. \doi{10.1016/j.jspi.2020.06.004}

Karl, A., & Zimmerman, D. (2020). Data and Code Supplement for 'A Diagnostic for Bias in Linear Mixed Model Estimators Induced by Dependence Between the Random Effects and the Corresponding Model Matrix'. Mendeley Data, V1. \doi{10.17632/tmynggddfm.1}
}
\author{
\strong{Maintainer}: Andrew T. Karl \email{akarl@asu.edu} (\href{https://orcid.org/0000-0002-5933-8706}{ORCID})

}
