% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_posterior_sample.R
\name{mlts_posterior_sample}
\alias{mlts_posterior_sample}
\title{Generate Posterior Predictive Samples for Multilevel Latent Time Series Models}
\usage{
mlts_posterior_sample(
  fit,
  draw_person_pars = FALSE,
  n_draws = 10,
  draws = NULL,
  as_matrix = TRUE
)
}
\arguments{
\item{fit}{An object of class \code{mlts.fit}, as returned by a fitted model using \code{mlts()}.}

\item{draw_person_pars}{Logical. If \code{TRUE}, samples are generated using person-specific parameters (random effects).
If \code{FALSE}, only population-level parameters are used. Defaults to \code{FALSE}.}

\item{n_draws}{Integer. Number of posterior draws to use for simulating replicated datasets. Ignored if \code{draws} is provided. Defaults to 10.}

\item{draws}{Optional integer vector indicating specific posterior draw indices to use. If \code{NULL}, \code{n_draws} draws are chosen with the maximum distance between posterior samples.}

\item{as_matrix}{Logical. Return replications of each variable as a matrix with \code{n_draw} rows, ready to run graphical posterior predictive checks using the \code{bayesplot} package.}
}
\value{
A list of replicated datasets, each as a \code{data.frame} with columns:
\describe{
\item{\code{Y_rep}}{Replication number.}
\item{\code{ID}}{Subject/cluster ID.}
\item{\code{time}}{Time point.}
\item{...}{One column per time-series variable defined in the model.}
}
}
\description{
The \code{mlts_posterior_sample()} function generates replicated datasets from a fitted
\code{mlts} model using draws from the posterior distribution. The function can
simulate data under the population model or based on individual-specific (random effect) parameters.
}
\details{
The function extracts posterior samples of population-level (and optionally individual-level) parameters
from a fitted \code{mlts} model and simulates replicated datasets from the posterior predictive distribution.
Each replication corresponds to a different posterior draw and reflects uncertainty in the model's parameters.
See \code{\link[bayesplot:PPC-overview]{PPC}} for an overview on graphical posterior predictive checks and how they can be performed.

If \code{draw_person_pars = TRUE}, the function uses sampled person-specific random effects and covariate effects
from the posterior to generate new data at the individual level. This requires that the model was fitted with
\code{monitor_person_pars = TRUE} in \code{\link[mlts]{mlts_fit}}. If this condition is not met, the function will
throw an error.

Posterior draws are either selected with the maximum distance between posterior samples (\code{n_draws}) or specified manually using the \code{draws} argument.
Optionally, left or right censoring is respected in the simulated data if such constraints were present in the model.
}
\examples{
\dontrun{
# build a simple vector-autoregressive mlts model with two time-series variables
var_model <- mlts_model(q = 2)

# simulate data from this model with default true values
# (true values are randomly drawn from normal distribution)
var_data <- mlts_sim(
  model = var_model,
  N = 50, TP = 30, # number of units and number of measurements per unit
  default = TRUE # use default parameter values
)

# fit model
fit <- mlts_fit(
  model = var_model,
  data = var_data,
  id = "ID", ts = c("Y1", "Y2"),
  time = "time",
  monitor_person_pars = TRUE
)

# Simulate 20 replications from the posterior
yreps <- mlts_posterior_sample(fit = fit, n_draws = 20)

# Include person-specific parameters in simulation
yreps <- mlts_posterior_sample(fit = fit, draw_person_pars = TRUE)

# Use specific posterior draws
yreps <- mlts_posterior_sample(fit = fit, draws = c(10, 50, 100))
}

}
\seealso{
\code{\link[mlts]{mlts_pp_check}} for plotting posterior predictive checks.
}
