% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-forecast-plot.R
\name{plot_modeltime_forecast}
\alias{plot_modeltime_forecast}
\title{Interactive Forecast Visualization}
\usage{
plot_modeltime_forecast(
  .data,
  .conf_interval_show = TRUE,
  .conf_interval_fill = "grey20",
  .conf_interval_alpha = 0.2,
  .smooth = FALSE,
  .legend_show = TRUE,
  .legend_max_width = 40,
  .facet_ncol = 1,
  .facet_nrow = 1,
  .facet_scales = "free_y",
  .title = "Forecast Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Legend",
  .interactive = TRUE,
  .plotly_slider = FALSE,
  .trelliscope = FALSE,
  .trelliscope_params = list(),
  ...
)
}
\arguments{
\item{.data}{A \code{tibble} that is the output of \code{\link[=modeltime_forecast]{modeltime_forecast()}}}

\item{.conf_interval_show}{Logical. Whether or not to include the confidence interval as a ribbon.}

\item{.conf_interval_fill}{Fill color for the confidence interval}

\item{.conf_interval_alpha}{Fill opacity for the confidence interval. Range (0, 1).}

\item{.smooth}{Logical - Whether or not to include a trendline smoother.
Uses See \code{\link[timetk:smooth_vec]{smooth_vec()}} to apply a LOESS smoother.}

\item{.legend_show}{Logical. Whether or not to show the legend.
Can save space with long model descriptions.}

\item{.legend_max_width}{Numeric. The width of truncation to apply to the legend text.}

\item{.facet_ncol}{Number of facet columns.}

\item{.facet_nrow}{Number of facet rows (only used for \code{.trelliscope = TRUE})}

\item{.facet_scales}{Control facet x & y-axis ranges.
Options include "fixed", "free", "free_y", "free_x"}

\item{.title}{Title for the plot}

\item{.x_lab}{X-axis label for the plot}

\item{.y_lab}{Y-axis label for the plot}

\item{.color_lab}{Legend label if a \code{color_var} is used.}

\item{.interactive}{Returns either a static (\code{ggplot2}) visualization or an interactive (\code{plotly}) visualization}

\item{.plotly_slider}{If \code{TRUE}, returns a plotly date range slider.}

\item{.trelliscope}{Returns either a normal plot or a trelliscopejs plot (great for many time series)
Must have \code{trelliscopejs} installed.}

\item{.trelliscope_params}{Pass parameters to the \code{trelliscopejs::facet_trelliscope()} function as a \code{list()}.
The only parameters that cannot be passed are:
\itemize{
\item \code{ncol}: use \code{.facet_ncol}
\item \code{nrow}: use \code{.facet_nrow}
\item \code{scales}: use \code{facet_scales}
\item \code{as_plotly}: use \code{.interactive}
}}

\item{...}{Additional arguments passed to \code{\link[timetk:plot_time_series]{timetk::plot_time_series()}}.}
}
\value{
A static \code{ggplot2} plot or an interactive \code{plotly} plot containing a forecast
}
\description{
This is a wrapper for \code{timetk::plot_time_series()} that generates an interactive (\code{plotly}) or static
(\code{ggplot2}) plot with the forecasted data.
}
\examples{
library(dplyr)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- FORECAST ----

models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_forecast(
        new_data    = testing(splits),
        actual_data = m750
    ) \%>\%
    plot_modeltime_forecast(.interactive = FALSE)

}
