% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_modsem}
\alias{bootstrap_modsem}
\alias{bootstrap_modsem.modsem_pi}
\alias{bootstrap_modsem.modsem_da}
\alias{bootstrap_modsem.function}
\title{Bootstrap a modsem Model}
\usage{
bootstrap_modsem(model = modsem, FUN, ...)

\method{bootstrap_modsem}{modsem_pi}(model, FUN = "coef", ...)

\method{bootstrap_modsem}{modsem_da}(
  model,
  FUN = "coef",
  R = 1000L,
  P.max = 1e+05,
  type = c("nonparametric", "parametric"),
  verbose = interactive(),
  calc.se = FALSE,
  optimize = FALSE,
  ...
)

\method{bootstrap_modsem}{`function`}(
  model = modsem,
  FUN = "coef",
  data,
  R = 1000L,
  verbose = interactive(),
  FUN.args = list(),
  cluster.boot = NULL,
  ...
)
}
\arguments{
\item{model}{A fitted \code{modsem} object, or a function to be bootstrapped
(e.g., \code{\link{modsem}}, \code{\link{modsem_da}} and \code{\link{modsem_pi}})}

\item{FUN}{A function that returns the statistic of interest when applied to
a fitted model.  The function must accept a single argument, the model
object, and should ideally return a numeric vector; see Value.}

\item{...}{Additional arguments forwarded to \code{lavaan::bootstrapLavaan}
for \code{\link{modsem_pi}} objects, or \code{\link{modsem_da}} for
\code{\link{modsem_da}} objects.}

\item{R}{number of bootstrap replicates.}

\item{P.max}{ceiling for the simulated population size.}

\item{type}{Bootstrap flavour, see Details.}

\item{verbose}{Should progress information be printed to the console?}

\item{calc.se}{Should standard errors for each replicate. Defaults to \code{FALSE}.}

\item{optimize}{Should starting values be re-optimized for each replicate. Defaults to \code{FALSE}.}

\item{data}{Dataset to be resampled.}

\item{FUN.args}{Arguments passed to \code{FUN}}

\item{cluster.boot}{Variable to cluster bootstrapping by}
}
\value{
Depending on the return type of \code{FUN} either
  \describe{
    \item{numeric}{A matrix with \code{R} rows (bootstrap replicates) and as
      many columns as \code{length(FUN(model))}.}
    \item{other}{A list of length \code{R}; each element is the raw output of
      \code{FUN}. \strong{NOTE}: Only applies for \code{\link{modsem_da}} objects}
  }
}
\description{
A generic interface for parametric and non-parametric bootstrap procedures
for structural equation models estimated with the \pkg{modsem} ecosystem.
The function dispatches on the class of \code{model}; currently dedicated
methods exist for \code{\link{modsem_pi}} (product‑indicator approach) and
\code{\link{modsem_da}} (distributional‑analytic approach).
}
\details{
A thin wrapper around \code{lavaan::bootstrapLavaan()} that performs the
  necessary book‑keeping so that \code{FUN} receives a fully‑featured
  \code{modsem_pi} object—rather than a bare \code{lavaan} fit—at every
  iteration.

The function internally resamples the observed data (non-parametric
  case) or simulates from the estimated parameter table (parametric case),
  feeds the sample to \code{\link{modsem_da}}, evaluates \code{FUN} on the
  refitted object and finally collates the results.

This is a more general version of \code{boostrap_modsem} for
  bootstrapping \code{modsem} functions, not modsem objects.
  \code{model} is now a function to be boostrapped, and \code{...}
  are now passed to the function (\code{model}), not \code{FUN}. To
  pass arguments to \code{FUN} use \code{FUN.args}.
}
\section{Methods (by class)}{
\itemize{
\item \code{bootstrap_modsem(modsem_pi)}: Bootstrap a \code{modsem_pi} model by delegating
to \code{\link[lavaan]{bootstrapLavaan}}.

\item \code{bootstrap_modsem(modsem_da)}: Parametric or non-parametric bootstrap for
\code{modsem_da} models.

\item \code{bootstrap_modsem(`function`)}: Non-parametric bootstrap of \code{modsem} functions

}}
\examples{

m1 <- '
  X =~ x1 + x2
  Z =~ z1 + z2
  Y =~ y1 + y2

  Y ~ X + Z + X:Z
'

fit_pi <- modsem(m1, oneInt)
bootstrap_modsem(fit_pi, FUN = coef, R = 10L)


m1 <- '
  X =~ x1 + x2
  Z =~ z1 + z2
  Y =~ y1 + y2

  Y ~ X + Z + X:Z
'

\dontrun{
fit_lms <- modsem(m1, oneInt, method = "lms")
bootstrap_modsem(fit_lms, FUN = coef, R = 10L)
}

tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC + INT:PBC
"

\dontrun{
boot <- bootstrap_modsem(model = modsem,
                         model.syntax = tpb, data = TPB,
                         method = "dblcent", rcs = TRUE,
                         rcs.scale.corrected = TRUE,
                         FUN = "coef", R = 50L)
coef <- apply(boot, MARGIN = 2, FUN = mean, na.rm = TRUE)
se   <- apply(boot, MARGIN = 2, FUN = sd, na.rm = TRUE)

cat("Parameter Estimates:\n")
print(coef)

cat("Standard Errors: \n")
print(se)

}
}
\seealso{
\code{\link[lavaan]{bootstrapLavaan}}, \code{\link{modsem_pi}},
  \code{\link{modsem_da}}
}
