% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periods.R
\name{nso_period_seq}
\alias{nso_period_seq}
\title{Create period codes}
\usage{
nso_period_seq(start, end, by = c("Y", "M"))
}
\arguments{
\item{start, end}{Start and end periods as character (YYYY or YYYYMM).}

\item{by}{'Y' for yearly or 'M' for monthly.}
}
\value{
Character vector of period codes.
}
\description{
Utilities to construct NSO period codes and sequences. For monthly data,
use YYYYMM; for yearly, use YYYY.
}
\examples{
# Generate yearly sequence
nso_period_seq("2020", "2024", by = "Y")

# Generate monthly sequence
nso_period_seq("202401", "202406", by = "M")
}
