% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{list_extensions}
\alias{list_extensions}
\title{List MotherDuck/DuckDB Extensions}
\usage{
list_extensions(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A tibble with one row per extension and columns describing its metadata
and current status.
}
\description{
Retrieves all available DuckDB or MotherDuck extensions along with their descriptions,
installation and load status.
}
\details{
The \code{list_extensions()} function queries the database for all extensions that are
available in the current DuckDB or MotherDuck connection. The returned tibble includes
information such as:
\itemize{
\item \code{extension_name}: Name of the extension.
\item \code{description}: Short description of the extension.
\item \code{installed}: Logical indicating if the extension is installed.
\item \code{loaded}: Logical indicating if the extension is currently loaded.
}

This is useful for determining which extensions can be installed or loaded using
\code{install_extensions()} or \code{load_extensions()}.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))

# List all available extensions
list_extensions(con)

DBI::dbDisconnect(con)
}
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
