% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build.rg}
\alias{build.rg}
\title{Reference Grid for \code{substitution} model.}
\usage{
build.rg(object, ref, at, parts, level, weight, fill = FALSE)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object.}

\item{ref}{Either a character value or vector or a dataset.
Can be \code{"grandmean"} and/or \code{"clustermean"}, or
a \code{data.frame} or \code{data.table} of user's specified reference grid consisting
of combinations of covariates over which predictions are made.
User's specified reference grid is only possible for simple substitution.
Single level models are default to \code{"grandmean"}.}

\item{at}{An optional named list of levels for the corresponding variables in the reference grid.}

\item{parts}{A optional character string specifying names of compositional parts that should be considered
in the substitution analysis. This should correspond to a single set of names of compositional parts specified
in the \code{complr} object. Default to the first composition in the \code{complr} object.}

\item{level}{A character string or vector.
Should the estimate of multilevel models focus on the \code{"between"} and/or \code{"within"} or \code{"aggregate"} variance?
Single-level models are default to \code{"aggregate"}.}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.}

\item{fill}{Logical value only relevant when \code{ref} is an user's specified reference grid
in which information about some, but not all covariates is provided
(e.g., models including age and sex as covariate but only age was provided in the reference grid).
If \code{TRUE}, the unspecified covariates are filled with the default reference grid.
If \code{FALSE}, users will be asked to provide a full reference grid.
Currently only support the default to \code{FALSE}.}
}
\value{
A reference grid consisting of a combination of covariates in \code{brmcoda}
}
\description{
Build a dataset for \code{fitted.brmcoda} used in \code{substitution} model
}
