% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmvmr_main.R
\name{fmvmr_twosample}
\alias{fmvmr_twosample}
\title{Two-Sample Joint Multivariable Functional MR}
\usage{
fmvmr_twosample(
  G_exposure,
  fpca_results,
  by_outcome,
  sy_outcome,
  ny_outcome,
  max_nPC1 = NA,
  max_nPC2 = NA,
  true_effects = NULL,
  verbose = TRUE
)
}
\arguments{
\item{G_exposure}{Genetic instrument matrix from the exposure sample (N × J)}

\item{fpca_results}{List of 2 FPCA objects}

\item{by_outcome}{Vector of SNP-outcome effect estimates (betas) from the outcome GWAS, length J}

\item{sy_outcome}{VVector of standard errors for SNP-outcome effects, length J}

\item{ny_outcome}{Sample size of the outcome GWAS}

\item{max_nPC1}{Maximum number of principal components to retain for exposure 1 (NA = automatically determined)}

\item{max_nPC2}{Maximum number of principal components to retain for exposure 2 (NA = automatically determined)}

\item{true_effects}{List containing true effects for exposure 1 and exposure 2 (simulation only)}

\item{verbose}{Print progress messages and diagnostics during computation}
}
\value{
fmvmr_twosample object
}
\description{
Joint estimation using outcome GWAS summary statistics.
Simplified approach: only needs by, sy, ny (not individual outcome data).
}
