% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distribution_strata.R
\name{strata_enrichment}
\alias{strata_enrichment}
\title{Calculate Phylostratum Enrichment}
\usage{
strata_enrichment(strata, selected_gene_ids)
}
\arguments{
\item{strata}{Named factor vector of phylostratum assignments (names are gene IDs)}

\item{selected_gene_ids}{Character vector of gene IDs to test for enrichment}
}
\value{
A data frame with columns:
\describe{
  \item{Stratum}{Phylostratum factor levels}
  \item{log_obs_exp}{Log2 ratio of observed vs expected proportions}
}
}
\description{
Calculate log2(observed/expected) enrichment ratios for phylostrata
in a selected gene set compared to the background distribution.
}
\details{
This function calculates enrichment or depletion of phylostrata in a gene set
by comparing the observed proportion of each stratum in the selected genes
to the expected proportion based on the background distribution in all genes.

Positive values indicate enrichment (more genes than expected), while negative 
values indicate depletion (fewer genes than expected).
}
\examples{
# Calculate enrichment for a gene set
enrichment <- strata_enrichment(example_phyex_set@strata, example_phyex_set@gene_ids[1:30])
print(enrichment)

}
