% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-arithmetic.R
\name{dual-arithmetic}
\alias{dual-arithmetic}
\alias{Ops,dualr,dualr-method}
\alias{Ops,dualr,numeric-method}
\alias{Ops,numeric,dualr-method}
\alias{+,dualr,dualr-method}
\alias{+,dualr,numeric-method}
\alias{+,numeric,dualr-method}
\alias{-,dualr,dualr-method}
\alias{-,dualr,numeric-method}
\alias{-,numeric,dualr-method}
\alias{*,dualr,dualr-method}
\alias{*,dualr,numeric-method}
\alias{*,numeric,dualr-method}
\alias{/,dualr,dualr-method}
\alias{/,dualr,numeric-method}
\alias{/,numeric,dualr-method}
\alias{^,dualr,dualr-method}
\alias{^,dualr,numeric-method}
\alias{^,numeric,dualr-method}
\alias{+,dualr,missing-method}
\alias{-,dualr,missing-method}
\alias{!,dualr-method}
\title{Arithmetic and comparison operators for dual numbers}
\usage{
\S4method{+}{dualr,dualr}(e1, e2)

\S4method{+}{dualr,numeric}(e1, e2)

\S4method{+}{numeric,dualr}(e1, e2)

\S4method{-}{dualr,dualr}(e1, e2)

\S4method{-}{dualr,numeric}(e1, e2)

\S4method{-}{numeric,dualr}(e1, e2)

\S4method{*}{dualr,dualr}(e1, e2)

\S4method{*}{dualr,numeric}(e1, e2)

\S4method{*}{numeric,dualr}(e1, e2)

\S4method{/}{dualr,dualr}(e1, e2)

\S4method{/}{dualr,numeric}(e1, e2)

\S4method{/}{numeric,dualr}(e1, e2)

\S4method{^}{dualr,dualr}(e1, e2)

\S4method{^}{dualr,numeric}(e1, e2)

\S4method{^}{numeric,dualr}(e1, e2)

\S4method{Ops}{dualr,dualr}(e1, e2)

\S4method{Ops}{dualr,numeric}(e1, e2)

\S4method{Ops}{numeric,dualr}(e1, e2)

\S4method{+}{dualr,missing}(e1, e2)

\S4method{-}{dualr,missing}(e1, e2)

\S4method{!}{dualr}(x)
}
\arguments{
\item{e1, e2}{Dual or numeric operands.}

\item{x}{A dual number (for unary \code{!}).}
}
\value{
A \code{dual} for arithmetic ops; logical for comparisons.
}
\description{
Implements arithmetic (\code{+}, \code{-}, \code{*}, \code{/}, \code{^}),
comparison (\code{==}, \code{!=}, \code{<}, \code{>}, \code{<=}, \code{>=}),
and logical (\code{&}, \code{|}) operators. Derivatives follow standard
calculus rules (sum, product, quotient, power, chain).
}
\examples{
x <- dual_variable(3)
y <- dual_variable(4)

value(x + y)
deriv(x * x)
value(x^2)
deriv(x^2)

x < y
x == y

}
