% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_mean}
\alias{lnr_mean}
\title{Mean Learner}
\usage{
lnr_mean(data, formula, weights = NULL)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
This is a very naive/simple learner that simply predicts the mean of the
outcome for every row of input \code{newdata}.  This is primarily
useful for benchmarking and confirming that other learners are
performing better than \code{lnr_mean}. Additionally, it may be the case
that some learners are over-fitting the data, and giving some weight to
\code{lnr_mean} helps to reduce over-fitting in \code{super_learner()}.
}
\examples{
lnr_mean(mtcars, mpg ~ hp)(mtcars)
}
\seealso{
learners
}
