test_that("nnumber works correctly", {
  expect_equal(nnumber(1000), "1.0 K")
  expect_equal(nnumber(1500, digits = 1), "1.5 K")
  expect_equal(nnumber(1000000), "1.0 Mn")
  expect_equal(nnumber(1234, unit = "custom"), "1.2 K")
  expect_equal(nnumber(100, prefix = "$"), "$100.0")
})

test_that("npercent works correctly", {
  expect_equal(npercent(0.25), "+25.0%")
  expect_equal(npercent(25, is_ratio = FALSE), "+25.0%")
  expect_equal(npercent(0.25, show_plus_sign = FALSE, digits = 0), "25%")
  expect_equal(npercent(0.5, show_growth_factor = TRUE), "+50.0% (Growth)")
  expect_equal(npercent(-0.5, show_growth_factor = TRUE), "-50.0% (Drop)")
  expect_equal(npercent(0.015, show_bps = TRUE), "+1.5% (+150 bps)")
})
