% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_like.R
\name{extractor3d}
\alias{extractor3d}
\alias{[,ArrayLike3D,numeric,missing,ANY-method}
\alias{[,ArrayLike3D,matrix,missing,ANY-method}
\alias{[,ArrayLike3D,missing,missing,ANY-method}
\alias{[,ArrayLike3D,missing,numeric,ANY-method}
\title{Array-like access for 3-dimensional data structures}
\usage{
\S4method{[}{ArrayLike3D,numeric,missing,ANY}(x, i, j, k, ..., drop = TRUE)

\S4method{[}{ArrayLike3D,matrix,missing,ANY}(x, i, j, k, ..., drop = TRUE)

\S4method{[}{ArrayLike3D,missing,missing,ANY}(x, i, j, k, ..., drop = TRUE)

\S4method{[}{ArrayLike3D,missing,numeric,ANY}(x, i, j, k, ..., drop = TRUE)
}
\arguments{
\item{x}{The 3-dimensional object to be accessed.}

\item{i}{First index or dimension.}

\item{j}{Second index or dimension.}

\item{k}{Third index or dimension.}

\item{...}{Additional arguments passed to methods.}

\item{drop}{Logical. If TRUE, the result is coerced to the lowest possible dimension.}
}
\value{
A subset of the input object, with dimensions depending on the indexing and the `drop` parameter.
}
\description{
This generic function provides array-like access for 3-dimensional data structures.
It allows for flexible indexing and subsetting of 3D arrays or array-like objects.
}
