% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aco.cores.R
\name{p.calculation}
\alias{p.calculation}
\title{Calculate selection probabilities for each node}
\usage{
p.calculation(nodeslst, prob_min = NULL)
}
\arguments{
\item{nodeslst}{A data frame of nodes, including columns:
\describe{
\item{phi}{Current pheromone level \eqn{\phi}}
\item{node.no}{Group ID for the decision step}
\item{p}{Probability of selection (to be calculated)}
}}

\item{prob_min}{Numeric scalar. Minimum probability each node is allowed to have
within its decision group. Set to NULL or 0 to disable smoothing.}
}
\value{
The updated node list with recalculated p values.
}
\description{
Calculates the probability of selecting each node in an ant colony
optimization search, based on pheromone levels \eqn{\phi}.
}
\details{
Within each decision group \eqn{G}, selection probabilities are computed from
pheromone levels \eqn{\phi} as:
\deqn{p_i = \frac{\phi_i}{\sum_{j \in G} \phi_j}}

If prob_min is enabled and any calculated probability falls below this value,
the algorithm:
\enumerate{
\item Sets all probabilities below prob_min to prob_min.
\item Redistributes the remaining probability mass proportionally among
the other nodes in the same group.
}

This acts as a probability smoothing mechanism, preventing premature
convergence by ensuring all nodes retain some chance of being explored.
}
\examples{
node.list <- initNodeList(search.space = "ivbase", phi0 = 1)
p.calculation(nodeslst = node.list, prob_min = 0.2)
}
\author{
Zhonghui Huang
}
