np.aov.test <- 
  function(x, groups, blocks = NULL, 
           var.equal = FALSE, median.test = FALSE, 
           R = 9999, parallel = FALSE, cl = NULL,
           perm.dist = TRUE, na.rm = TRUE){
    # Nonparametric One-Way and Repeated Measures ANOVA Tests (Mean/Median)
    # Nathaniel E. Helwig (helwig@umn.edu)
    # last updated: 2026-01-15
    
    
    ### check x
    x <- as.matrix(x)
    N <- nrow(x)
    nvar <- ncol(x)
    if(na.rm) x <- na.omit(x)
    
    ### check groups
    groups <- as.factor(groups)
    if(length(groups) != N) stop("Inputs 'x' and 'groups' must satisfy:  nrow(x) == length(groups)")
    ngroups <- nlevels(groups)
    if(na.rm) groups <- na.omit(groups)
    
    ### check blocks
    repeated <- FALSE
    if(!is.null(blocks)){
      repeated <- TRUE
      blocks <- as.factor(blocks)
      if(length(blocks) != N) stop("Inputs 'x' and 'blocks' must satisfy:  nrow(x) == length(blocks)")
      nblocks <- nlevels(blocks)
      if(N != nblocks * ngroups) stop("Dimension mismatch (data are not fully crossed).\n Inputs must satisfy:  nrow(x) = nlevels(groups) * nlevels(blocks)")
      if(na.rm) blocks <- na.omit(blocks)
    }
    
    ### one-way or repeated measures?
    if(is.null(blocks)){
      pt <- rand.test.aov1(x = x, g = groups, 
                           var.equal = var.equal, 
                           median.test = median.test,
                           R = R, parallel = parallel, cl = cl, 
                           perm.dist = perm.dist)
    } else {
      pt <- rand.test.aov2(x = x, g = groups, b = blocks,
                           var.equal = var.equal, 
                           median.test = median.test,
                           R = R, parallel = parallel, cl = cl, 
                           perm.dist = perm.dist)
    } # end if(is.null(blocks))
    pt$repeated <- repeated
    
    ### append method
    if(median.test){
      aaa <- paste(ifelse(repeated, "Friedman", "Kurskal-Wallis"), "ANOVA Test")
      bbb <- ifelse(var.equal, "(Equal Variances)", "(Unequal Variances)")
    } else {
      aaa <- paste(ifelse(repeated, "Repeated Measures", "One-Way"), "ANOVA Test")
      bbb <- ifelse(var.equal, "(Equal Variances)", "(Unequal Variances)")
    }
    pt$method <- paste(aaa, bbb)
    
    ### add ngroups and blocks
    pt$ngroups <- ngroups
    if(!is.null(blocks)) pt$nblocks <- nblocks
    
    ### return results
    class(pt) <- "np.aov.test"
    return(pt)
    
  } # end np.aov.test
