% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_gadm.R
\name{assoc_gadm}
\alias{assoc_gadm}
\title{Associate other data sources with gadm IDs}
\usage{
assoc_gadm(
  df,
  lonlat_names = c("Longitude", "Latitude"),
  cache_location = NULL,
  basereq = ad_basereq()
)
}
\arguments{
\item{df}{the source data to bind gadm IDs to. This \strong{must} contain decimal lonlat data!}

\item{lonlat_names}{a vector containing the column names of the longitude and latitude columns \strong{IN THAT ORDER}!}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{basereq}{the url of the AREAdata database (usually generated by \code{\link[=ad_basereq]{ad_basereq()}}). If \code{NA}, uses the default.}
}
\value{
A matrix of the \code{data} with added gadm columns.
}
\description{
Intelligently bind together data with gadm IDs at all scales.
}
\section{Caching}{

This will \strong{ALWAYS} get and cache gid level 2 data sources. These files are about 80MB total, so if you are running on a metered connection do beware of this.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
vtdf <- search_hub("Aedes aegypti", "vt") |>
  tail(20) |>
  fetch() |>
  glean(cols = c(
    "DatasetID",
    "Latitude",
    "Longitude",
    "Interactor1Genus",
    "Interactor1Species"
    ), returnunique = TRUE) |>
  assoc_gadm(lonlat_names = c("Longitude", "Latitude"))

\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
