% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_ad.R
\name{fetch_ad}
\alias{fetch_ad}
\title{Fetch AREAdata dataset}
\usage{
fetch_ad(
  metric = "temp",
  gid = 0,
  use_cache = TRUE,
  cache_location = NULL,
  refresh_cache = FALSE,
  timeout = 240,
  basereq = ad_basereq()
)
}
\arguments{
\item{metric}{the metric to retrieve from areadata.}

\item{gid}{the spatial scale to retrieve (0 = country-level, 1=province-level ...).}

\item{use_cache}{load files from cache if possible, and save them if not present.}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{refresh_cache}{force a refresh of the relevant cached data (and enables use_cache).}

\item{timeout}{timeout for data download from figshare/github in seconds.}

\item{basereq}{the url of the AREAdata database (usually generated by \code{\link[=ad_basereq]{ad_basereq()}}). If \code{NA}, uses the default.}
}
\value{
A \code{ohvbd.ad.matrix} of the requested data (with added attributes for gid and metric).
}
\description{
Retrieve AREAdata dataset/s specified by metric and spatial scale (GID).
}
\section{Valid metrics}{

The following metrics are valid (alternative names are listed in brackets):
\itemize{
\item \code{temp} (\emph{temperature})
\item \code{spechumid} (\emph{specific humidity})
\item \code{relhumid} (\emph{relative humidity})
\item \code{uv} (\emph{ultraviolet})
\item \code{precip} (\emph{precipitation, rainfall})
\item \code{popdens} (\emph{population density, population})
\item \code{forecast} (\emph{future climate, future})
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_ad(metric="temp", gid=0)
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{areadata}
