% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ohvbd-extradocs.R
\name{ohvbd_attrs}
\alias{ohvbd_attrs}
\title{Internal attributes}
\description{
\code{ohvbd} uses a number of internal attributes to track data states within pipelines.
Generally these are not designed to be user-modified. They are, however, listed here for completeness (and curiosity).

It is typically not a good idea to manually modify these attributes directly unless a helper such as \code{\link[=force_db]{force_db()}} or \code{\link[=ohvbd_db]{ohvbd_db()}} is provided.
Even then, modifying these attributes may cause unexpected errors or data inconsistencies. These errors may not be signalled to the user by \code{ohvbd}, and they may not be obvious \emph{or even detectable}.

Be sure when modifying the \code{db} attribute that the value you set it to is consistent with the origin of your data, and that the value is a db known to ohvbd.
}
\section{Summary table of attributes}{
\tabular{llll}{
   Attribute \tab  \tab Description \tab Object/s \cr
   \strong{db} \tab  \tab The database from which the object has been retrieved. \tab \code{ohvbd.ids}, \code{ohvbd.responses},  \code{ohvbd.data.frame}, \code{ohvbd.ad.matrix} \cr
   \strong{metric} \tab  \tab The AD metric. \tab \code{ohvbd.ad.matrix} \cr
   \strong{gid} \tab  \tab The AD aggregation level. \tab \code{ohvbd.ad.matrix} \cr
   \strong{cached} \tab  \tab Whether the data was loaded from a cache. \tab Any \cr
   \strong{writetime} \tab  \tab The time at which a data file was originally cached. \tab Any \cr
   \strong{query} \tab  \tab The search query sent to the Hub. \tab \code{ohvbd.hub.search} \cr
   \strong{searchparams} \tab  \tab Any extra parameters sent to the Hub. \tab \code{ohvbd.hub.search} \cr
}


\emph{Note: (AD = AREAdata)}
}

\section{db}{


\emph{Type: string}

The \strong{db} attribute indicates to \code{ohvbd} where an object originated.
It is used to determine appropriate method dispatch (such as with \code{\link[=fetch]{fetch()}}) and to check that pipelines are sensible constructed.
}

\section{metric}{


\emph{Type: string}

\strong{metric} signifies what AD metric the matrix contains. It is predominantly (but not exclusively) used for formatting and caching.
}

\section{gid}{


\emph{Type: integer}

\strong{gid} represents the spatial scale of data from AD. It is used for a variety of spatial operations.
}

\section{cached}{


\emph{Type: boolean}

\strong{cached} objects receive this flag at write-time. It sticks with the object when it is reloaded, and is mostly used for UI/UX purposes.
}

\section{writetime}{


\emph{Type: POSIXct}

\strong{writetime} stores the time at which a cached object (that is likely to become stale) was written to the cache.
}

\section{query}{


\emph{Type: string}

Simply stores the base \strong{query} that was sent to the \href{https://vbdhub.org}{vbdhub} search API.
}

\section{searchparams}{


\emph{Type: named list}

A record of any other search parameters that were sent to the \href{https://vbdhub.org}{vbdhub} search API (e.g. species IDs etc.).
}

\author{
Francis Windram
}
