% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_vd_smart.R
\name{search_vd_smart}
\alias{search_vd_smart}
\title{Search VecDyn using the explorer's filters}
\usage{
search_vd_smart(field, operator, value, basereq = vb_basereq())
}
\arguments{
\item{field}{a field of VecDyn to search.}

\item{operator}{an operator to use when searching.}

\item{value}{the value that the field might/might not be.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
An \code{ohvbd.ids} vector of VecDyn dataset IDs.
}
\description{
Retrieve the IDs for any VecDyn datasets matching the given filter.
}
\section{Valid fields}{

The following field names are valid (shortcut names are listed in brackets):
\itemize{
\item \code{SpeciesName} (\emph{species})
\item \code{Title}
\item \code{Collections}
\item \code{Years} (\emph{yrs})
\item \code{CollectionMethods} (\emph{methods})
\item \code{Tags}
}
}

\section{Valid operators}{

The following operators are valid (alternative names are listed in brackets):
\itemize{
\item \code{contains} (\emph{contain, has, have})
\item \code{!contains} (\emph{!contains, !has, !have, ncontains})
\item \code{equals} (\emph{=, ==, equal, eq})
\item \code{!equals} (\emph{!=, not, !equal, !eq, neq})
\item \code{starts} (\emph{starts with, start with, start, sw})
\item \code{!starts} (\emph{not starts with, not start with, !start, nsw})
\item \verb{in} (\emph{within})
\item \verb{!in} (\emph{not in, not within, !within, nin})
\item \code{greater} (\emph{greater than, gt, >})
\item \code{less} (\emph{less than, lt, <})
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_vd_smart("Collections", "gt", "1000")
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vecdyn}
