% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_vt.R
\name{search_vt}
\alias{search_vt}
\title{Search VecTraits by keyword}
\usage{
search_vt(keywords, basereq = vb_basereq())
}
\arguments{
\item{keywords}{either a string of search terms separated by spaces, or a vector of keywords.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
An \code{ohvbd.ids} vector of VecTraits dataset IDs.
}
\description{
Retrieve the IDs for any VecTraits datasets matching the given keywords.
}
\note{
\code{\link[=search_hub]{search_hub()}} is now preferred for keyword searches:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# old style
search_vt(c("Ixodes", "ricinus")

# new style
search_hub("Ixodes ricinus", db = "vt")
}\if{html}{\out{</div>}}

\code{search_vt()} may be deprecated in the future.
}
\section{Warning}{

The ids returned from the server (and thus this function) do not necessarily precisely match the keywords that were requested.

For example \code{search_vt("United Kingdom")} does not return only items found in the United Kingdom. Instead it returns items where some part of the string "United Kingdom" appears in one of the indexed columns.

The indexed columns of VecTraits are:
\itemize{
\item \code{DatasetID}
\item \code{OriginalTraitName}
\item \code{Variables}
\item \code{Interactor1Order}
\item \code{Interactor1Family}
\item \code{Interactor1Genus}
\item \code{Interactor1Species}
\item \code{Interactor1Stage}
\item \code{Interactor1Sex}
\item \code{Interactor2Genus}
\item \code{Interactor2Species}
\item \code{Citation}
\item \code{DOI}
\item \code{CuratedByDOI}
\item \code{SubmittedBy}
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_vt("Aedes aegypti")

search_vt(c("Aedes", "aegypti"))
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vectraits}
