% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{detect_duplicates}
\alias{detect_duplicates}
\title{Detect Duplicate MRM Transitions}
\usage{
detect_duplicates(
  data,
  polarity_col = "polarity",
  retention_time_col = "retention_time",
  mass_info_col = "Mass Info",
  component_name_col = "component_name"
)
}
\arguments{
\item{data}{A tibble containing the MRM transition data.}

\item{polarity_col}{Name of the column containing polarity information.}

\item{retention_time_col}{Name of the column containing retention time information.}

\item{mass_info_col}{Name of the column containing mass information.}

\item{component_name_col}{Name of the column containing component name information.}
}
\value{
The original tibble with an added `MRM_Duplicate_Flag` column.
}
\description{
This function adds a column `MRM_Duplicate_Flag` to the tibble, indicating if a row is a duplicate based on the criteria:
same polarity, less than a 1-minute retention time difference, and the same MRM transition (Q1/Q3).
}
\examples{
\dontrun{
sample_data <- tibble::tribble(
  ~polarity, ~`retention_time`, ~`Mass Info`, ~`component_name`,
  "Positive", 1.95, "61.0 / 44.0", "Urea_pos",
  "Positive", 8.34, "206.0 / 189.0", "Lipoamide_pos",
  "Positive", 2.18, "339.1 / 110.0", "AICAR_pos",
  "Positive", 1.76, "175.1 / 70.0", "Arginine_pos",
  "Positive", 1.75, "176.2 / 159.1", "Citrulline_pos",
  "Positive", 8.90, "198.0 / 181.0", "Dopa_pos",
  "Positive", 2.06, "132.1 / 86.0", "Isoleucine_pos",
  "Positive", 1.92, "132.1 / 43.1", "Leucine_pos",
  "Positive", 1.76, "150.1 / 133.0", "Methionine_pos",
  "Positive", 7.79, "166.1 / 103.0", "Phenylalanine_pos"
)
detect_duplicates(sample_data, "polarity", "retention_time", "Mass Info", "component_name")
}
}
\author{
Yaoxiang Li
}
