% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateResultArgument}
\alias{validateResultArgument}
\title{Validate if a an object is a valid 'summarised_result' object.}
\usage{
validateResultArgument(
  result,
  checkNoDuplicates = FALSE,
  checkNameLevel = FALSE,
  checkSuppression = FALSE,
  validation = "error",
  call = parent.frame()
)
}
\arguments{
\item{result}{summarised_result object to validate.}

\item{checkNoDuplicates}{Whether there are not allowed duplicates in the
result object.}

\item{checkNameLevel}{Whether the name-level paired columns are can be
correctly split.}

\item{checkSuppression}{Whether the suppression in the result object is well
defined.}

\item{validation}{Only error is supported at the moment.}

\item{call}{parent.frame}
}
\value{
summarise result object
}
\description{
Validate if a an object is a valid 'summarised_result' object.
}
\examples{
x <- dplyr::tibble(
  "result_id" = 1L,
  "cdm_name" = "eunomia",
  "group_name" = "cohort_name",
  "group_level" = "my_cohort",
  "strata_name" = c("sex", "sex &&& age_group", "sex &&& year"),
  "strata_level" = c("Female", "Male &&& <40", "Female &&& 2010"),
  "variable_name" = "number subjects",
  "variable_level" = NA_character_,
  "estimate_name" = "count",
  "estimate_type" = "integer",
  "estimate_value" = c("100", "44", "14"),
  "additional_name" = "overall",
  "additional_level" = "overall"
) |>
  newSummarisedResult()

validateResultArgument(x)

}
