% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.taxonomy.R
\name{opal.taxonomy_download}
\alias{opal.taxonomy_download}
\title{Download a taxonomy file}
\usage{
opal.taxonomy_download(opal, taxonomy, destination = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{taxonomy}{Name of the taxonomy.}

\item{destination}{Path to the taxonomy YAML file. If not provided, the downloaded file will
have the taxonomy name with the '.yml' extension and will be located in the working directory.}
}
\description{
Download a taxonomy stored in a file in YAML format.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.taxonomy_download(o, 'Mlstr_area', '~/some/dir/Mlstr_area.yml')
opal.logout(o)
}
}
\seealso{
Other taxonomy functions: 
\code{\link{opal.taxonomies}()},
\code{\link{opal.taxonomy}()},
\code{\link{opal.taxonomy_delete}()},
\code{\link{opal.taxonomy_upload}()},
\code{\link{opal.terms}()},
\code{\link{opal.vocabularies}()},
\code{\link{opal.vocabulary}()}
}
\concept{taxonomy functions}
