% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_delete}
\alias{opal.resource_delete}
\title{Delete a resource reference}
\usage{
opal.resource_delete(opal, project, resource, silent = TRUE)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the resource is located.}

\item{resource}{Resource name to be deleted.}

\item{silent}{Warn if resource does not exist, default is TRUE.}
}
\description{
Removes the reference to a resource. The targeted resource remains untouched.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_delete(o, "RSRC", "CNSIM4")
opal.logout(o)
}
}
\seealso{
Other resource functions: 
\code{\link{opal.resource}()},
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resource_perm}()},
\code{\link{opal.resource_perm_add}()},
\code{\link{opal.resource_perm_delete}()},
\code{\link{opal.resources}()},
\code{\link{opal.resources_perm}()},
\code{\link{opal.resources_perm_add}()},
\code{\link{opal.resources_perm_delete}()}
}
\concept{resource functions}
