% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_fill}
\alias{create_fill}
\title{Create fill pattern}
\usage{
create_fill(
  gradient_fill = "",
  pattern_type = "",
  bg_color = NULL,
  fg_color = NULL,
  ...
)
}
\arguments{
\item{gradient_fill}{Character, specifying complex gradient fills.}

\item{pattern_type}{Character, specifying the fill pattern type. Valid values are "none" (default), "solid", "mediumGray", "darkGray", "lightGray", "darkHorizontal", "darkVertical", "darkDown", "darkUp", "darkGrid", "darkTrellis", "lightHorizontal", "lightVertical", "lightDown", "lightUp", "lightGrid", "lightTrellis", "gray125", "gray0625".}

\item{bg_color}{Character, specifying the background color in hex8 format (alpha, red, green, blue) for pattern fills.}

\item{fg_color}{Character, specifying the foreground color in hex8 format (alpha, red, green, blue) for pattern fills.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A formatted fill pattern object to be used in a spreadsheet.
}
\description{
This function creates fill patterns for a cell in a spreadsheet. Fill patterns can be simple solid colors or more complex gradient fills. For certain pattern types, two colors are needed.
}
\examples{
# Create a solid fill pattern with foreground color
fill <- create_fill(
  pattern_type = "solid",
  fg_color = wb_color(hex = "FFFF0000")
)

}
\seealso{
\code{\link[=wb_add_fill]{wb_add_fill()}}

Other style creating functions: 
\code{\link{create_border}()},
\code{\link{create_cell_style}()},
\code{\link{create_colors_xml}()},
\code{\link{create_dxfs_style}()},
\code{\link{create_font}()},
\code{\link{create_numfmt}()},
\code{\link{create_tablestyle}()}
}
\concept{style creating functions}
