% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_border}
\alias{wb_add_border}
\title{Modify borders in a cell region of a worksheet}
\usage{
wb_add_border(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  bottom_color = wb_color(hex = "FF000000"),
  left_color = wb_color(hex = "FF000000"),
  right_color = wb_color(hex = "FF000000"),
  top_color = wb_color(hex = "FF000000"),
  bottom_border = "thin",
  left_border = "thin",
  right_border = "thin",
  top_border = "thin",
  inner_hgrid = NULL,
  inner_hcolor = NULL,
  inner_vgrid = NULL,
  inner_vcolor = NULL,
  update = FALSE,
  diagonal_up = NULL,
  diagonal_down = NULL,
  diagonal_color = NULL,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet to modify. Defaults to
the current sheet.}

\item{dims}{A character string defining the cell range (e.g., "A1", "B2:G10").}

\item{top_color, bottom_color, left_color, right_color}{The colors for the
exterior edges. Accepts \code{\link[=wb_color]{wb_color()}} objects or hex codes.}

\item{top_border, bottom_border, left_border, right_border}{The border style
for the exterior edges of the range.}

\item{inner_hgrid, inner_vgrid}{The border style for internal horizontal
and vertical grid lines within a range.}

\item{inner_hcolor, inner_vcolor}{The colors for internal grid lines.}

\item{update}{Logical or \code{NULL}. If \code{TRUE}, updates existing borders.
If \code{NULL}, removes borders. If \code{FALSE} (default), overwrites existing
styles with the new definition.}

\item{diagonal_up, diagonal_down}{Character string for the diagonal line
style (e.g., "thin").}

\item{diagonal_color}{A \code{\link[=wb_color]{wb_color()}} object for the diagonal lines.}

\item{...}{Additional arguments.}
}
\description{
The \code{wb_add_border()} function provides a high-level interface for applying
and managing cell borders within a \code{wbWorkbook}. It is designed to handle
both single cells and multi-cell regions, with built-in logic to differentiate
between exterior boundary borders and interior grid lines.
}
\details{
When applied to a range of cells (e.g., "A1:C3"), \code{wb_add_border()} treats
the selection as a single cohesive block. Parameters like \code{top_border} and
\code{left_border} apply only to the outermost edges of the entire range. To
draw lines between cells within the range, the \code{inner_hgrid} (horizontal)
and \code{inner_vgrid} (vertical) arguments are used.

The function supports all standard spreadsheet border styles (e.g., "thin",
"thick", "double", "dotted"). If \code{update = TRUE}, the function attempts
to merge new border definitions with existing ones, preserving overlapping
styles where possible. Setting \code{update = NULL} acts as a reset, removing
all border styles from the specified \code{dims} and returning them to the
workbook default.

For specialized needs, diagonal borders can be added using \code{diagonal_up}
and \code{diagonal_down}. Note that the OpenXML specification typically restricts
a cell to a single diagonal line style.
}
\section{Notes}{

\itemize{
\item The function internally partitions the \code{dims} range into nine zones
(corners, edges, and core) to apply the correct combination of
exterior and interior borders efficiently.
\item Color and style arguments must be paired; if a style is \code{NULL}, any
assigned color for that side will be ignored.
\item All border styles are registered in the workbook's global style
catalog to ensure XML consistency.
}
}

\examples{
wb <- wb_workbook()
wb <- wb_add_worksheet(wb, "S1")
wb <- wb_add_data(wb, "S1", mtcars)
wb <- wb_add_border(wb, 1, dims = "A1:K1",
 left_border = NULL, right_border = NULL,
 top_border = NULL, bottom_border = "double")
wb <- wb_add_border(wb, 1, dims = "A5",
 left_border = "dotted", right_border = "dotted",
 top_border = "hair", bottom_border = "thick")
wb <- wb_add_border(wb, 1, dims = "C2:C5")
wb <- wb_add_border(wb, 1, dims = "G2:H3")

wb <- wb_add_border(wb, 1, dims = "G12:H13",
 left_color = wb_color(hex = "FF9400D3"), right_color = wb_color(hex = "FF4B0082"),
 top_color = wb_color(hex = "FF0000FF"), bottom_color = wb_color(hex = "FF00FF00"))
wb <- wb_add_border(wb, 1, dims = "A20:C23")
wb <- wb_add_border(wb, 1, dims = "B12:D14",
 left_color = wb_color(hex = "FFFFFF00"), right_color = wb_color(hex = "FFFF7F00"),
 bottom_color = wb_color(hex = "FFFF0000"))
wb <- wb_add_border(wb, 1, dims = "D28:E28")

# With chaining

wb <- wb_workbook()
wb$add_worksheet("S1")$add_data("S1", mtcars)
wb$add_border(1, dims = "A1:K1",
 left_border = NULL, right_border = NULL,
 top_border = NULL, bottom_border = "double")
wb$add_border(1, dims = "A5",
 left_border = "dotted", right_border = "dotted",
 top_border = "hair", bottom_border = "thick")
wb$add_border(1, dims = "C2:C5")
wb$add_border(1, dims = "G2:H3")
wb$add_border(1, dims = "G12:H13",
 left_color = wb_color(hex = "FF9400D3"), right_color = wb_color(hex = "FF4B0082"),
 top_color = wb_color(hex = "FF0000FF"), bottom_color = wb_color(hex = "FF00FF00"))
wb$add_border(1, dims = "A20:C23")
wb$add_border(1, dims = "B12:D14",
 left_color = wb_color(hex = "FFFFFF00"), right_color = wb_color(hex = "FFFF7F00"),
 bottom_color = wb_color(hex = "FFFF0000"))
wb$add_border(1, dims = "D28:E28")
# if (interactive()) wb$open()

wb <- wb_workbook()
wb$add_worksheet("S1")$add_data("S1", mtcars)
wb$add_border(1, dims = "A2:K33", inner_vgrid = "thin",
 inner_vcolor = wb_color(hex = "FF808080"))

wb$add_worksheet()$
  add_border(dims = "B2:D4", bottom_border = "thick", left_border = "thick",
    right_border = "thick", top_border = "thick")$
  add_border(dims = "C3:E5", update = TRUE)

wb$add_worksheet()$
  add_border(
    dims = "B2:D4",
    diagonal_up = "thin",
    diagonal_down = "thin",
    diagonal_color = wb_color("red")
  )
}
\seealso{
\code{\link[=create_border]{create_border()}}

Other styles: 
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
