% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCullagh_conditional_symmetry.R
\name{McCullagh_conditional_symmetry}
\alias{McCullagh_conditional_symmetry}
\title{Fits the McCullagh (1978) conditional-symmetry model.}
\usage{
McCullagh_conditional_symmetry(n, max_iter = 5, verbose = FALSE)
}
\arguments{
\item{n}{matrix of observed counts}

\item{max_iter}{maximum number of iterations to maximize the log(likelihood)}

\item{verbose}{should cycle-by-cycle info be printed. Default is FALSE.}
}
\value{
a list containing
   theta: the asymmetry parameter
   chisq: chi-square
   g_squared: likelihood ratio G^2
   df: degrees of freedom
}
\description{
McCullagh, P. (1978).  A class of parametric models for the analysis of
square contingency tables with ordered categories.  Biometrika, 65(2) 413-418.
}
\examples{
McCullagh_conditional_symmetry(vision_data)
}
