% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmchange.R
\name{osmchange_create}
\alias{osmchange_create}
\title{\code{osmchange} to create OSM objects}
\usage{
osmchange_create(x, format = c("R", "osc", "xml"))
}
\arguments{
\item{x}{A \link{osmapi_objects} with columns \code{type}, \code{changeset} + column \code{members} for ways and relations + \code{lat}
and \code{lon} for nodes + tags if needed.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"osc"} (\code{"xml"} is a synonym for \code{"osc"}).}
}
\value{
If \code{format = "R"}, returns a \code{osmapi_OsmChange} data frame with one OSM edition per row.
If \code{format = "osc"} or \code{format = "xml"}, returns a \link[xml2:oldclass]{xml2::xml_document} following the
\href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange format} that can be saved with \code{\link[xml2:write_xml]{xml2::write_xml()}} and
opened in other applications such as JOSM.

The results are ready to send the editions to the servers with \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}}.
}
\description{
Prepare data to create OSM objects.
}
\details{
Objects IDs are unknown and will be allocated by the server. If \code{id} column is missing in \code{x}, a negative
placeholders will be used. Check \href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange page} for details about
how to refer to objects still not created to define the members of relations and nodes of ways.
}
\examples{
d <- data.frame(
  type = c("node", "node", "way", "relation"),
  id = -(1:4),
  lat = c(0, 1, NA, NA),
  lon = c(0, 1, NA, NA),
  name = c(NA, NA, "My way", "Our relation"),
  type.1 = c(NA, NA, NA, "Column clash!")
)
d$members <- list(
  NULL, NULL, -(1:2),
  matrix(
    c("node", "-1", NA, "node", "-2", NA, "way", "-3", "outer"),
    nrow = 3, ncol = 3, byrow = TRUE, dimnames = list(NULL, c("type", "ref", "role"))
  )
)
obj <- osmapi_objects(d, tag_columns = c(name = "name", type = "type.1"))
osmcha <- osmchange_create(obj)
osmcha
}
\seealso{
Other OsmChange's functions: 
\code{\link{osm_diff_upload_changeset}()},
\code{\link{osm_download_changeset}()},
\code{\link{osmchange_delete}()},
\code{\link{osmchange_modify}()}
}
\concept{OsmChange's functions}
