% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_formula.R
\name{WBFormula}
\alias{WBFormula}
\title{WBFormula class for within-between model formula representation}
\usage{
WBFormula(
  raw_formula,
  dv,
  varying = character(0),
  constants = character(0),
  v_info = NULL,
  wint_labs = NULL,
  cint_labs = NULL,
  bint_labs = NULL,
  ranefs = NULL,
  data = NULL,
  allvars = NULL,
  conds = NULL,
  matrix_terms = NULL
)
}
\arguments{
\item{raw_formula}{The original Formula object}

\item{dv}{The dependent variable name}

\item{varying}{Character vector of time-varying predictor terms}

\item{constants}{Character vector of time-invariant predictor terms}

\item{v_info}{Tibble with columns: term, root, lag, meanvar}

\item{wint_labs}{Character vector of within x within interaction labels}

\item{cint_labs}{Character vector of cross-level interaction labels}

\item{bint_labs}{Character vector of between x between interaction labels}

\item{ranefs}{Character vector of random effects specifications}

\item{data}{The data frame (with any expanded factors)}

\item{allvars}{Character vector of all variables needed (passed from parser)}

\item{conds}{Integer number of formula conditions/parts}

\item{matrix_terms}{Optional list of metadata for matrix-returning terms
detected in the varying part of the formula (e.g., \code{splines::ns()},
\code{splines::bs()}, \code{stats::poly()}). These terms are expanded into
within- and between- component columns during data preparation.}
}
\value{
A WBFormula S3 object
}
\description{
S3 class that represents a parsed within-between formula.
This provides a structured intermediate representation between the
user-specified formula and the final lme4 formula.

Constructor for the WBFormula S3 class.
}
\keyword{internal}
