% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sort_terms}
\alias{sort_terms}
\title{Sort ANOVA or Regression Table by Predictors/Effects}
\usage{
sort_terms(x, colname)
}
\arguments{
\item{x}{A data frame. For example, the table element produced by \code{\link[=apa_print]{apa_print()}}.}

\item{colname}{Character. Column name of the \code{data.frame} containing the terms to sort.}
}
\value{
Returns the same \code{data.frame} with reordered rows.
}
\description{
Sort rows in ANOVA or regression tables produced by \code{\link[=apa_print]{apa_print()}}
by complexity (i.e., main effects, two-way interactions, three-way interactions, etc.).
}
\examples{
## From Venables and Ripley (2002) p. 165.
npk_aov <- aov(yield ~ block + N * P * K, npk)
npk_aov_results <- apa_print(npk_aov)
sort_terms(npk_aov_results$table, "term")
}
