% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_lightgbm.R
\name{details_boost_tree_lightgbm}
\alias{details_boost_tree_lightgbm}
\title{Boosted trees via lightgbm}
\description{
\code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}} creates a series of decision trees
forming an ensemble. Each tree depends on the results of previous trees.
All trees in the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there are multiple modes: regression and classification
\subsection{Tuning Parameters}{

This model has 6 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: -1)
\item \code{trees}: # Trees (type: integer, default: 100)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.1)
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{min_n}: Minimal Node Size (type: integer, default: 20)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default: 0)
}

The \code{mtry} parameter gives the \emph{number} of predictors that will be
randomly sampled at each split. The default is to use all predictors.

Rather than as a number,
\code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}}’s \code{feature_fraction}
argument encodes \code{mtry} as the \emph{proportion} of predictors that will be
randomly sampled at each split. parsnip translates \code{mtry}, supplied as
the \emph{number} of predictors, to a proportion under the hood. That is, the
user should still supply the argument as \code{mtry} to \code{boost_tree()}, and
do so in its sense as a number rather than a proportion; before passing
\code{mtry} to \code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}}, parsnip will
convert the \code{mtry} value to a proportion.

Note that parsnip’s translation can be overridden via the \code{counts}
argument, supplied to \code{set_engine()}. By default, \code{counts} is set to
\code{TRUE}, but supplying the argument \code{counts = FALSE} allows the user to
supply \code{mtry} as a proportion rather than a number.
}

\subsection{Translation from parsnip to the original package (regression)}{

The \strong{bonsai} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), tree_depth = integer(), 
  learn_rate = numeric(), min_n = integer(), loss_reduction = numeric()
) |>
  set_engine("lightgbm") |>
  set_mode("regression") |>
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
## 
## Computational engine: lightgbm 
## 
## Model fit template:
## bonsai::train_lightgbm(x = missing_arg(), y = missing_arg(), 
##     weights = missing_arg(), feature_fraction_bynode = integer(), 
##     num_iterations = integer(), min_data_in_leaf = integer(), 
##     max_depth = integer(), learning_rate = numeric(), min_gain_to_split = numeric(), 
##     verbose = -1, num_threads = 0, seed = sample.int(10^5, 1), 
##     deterministic = TRUE)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

The \strong{bonsai} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), tree_depth = integer(), 
  learn_rate = numeric(), min_n = integer(), loss_reduction = numeric()
) |> 
  set_engine("lightgbm") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
## 
## Computational engine: lightgbm 
## 
## Model fit template:
## bonsai::train_lightgbm(x = missing_arg(), y = missing_arg(), 
##     weights = missing_arg(), feature_fraction_bynode = integer(), 
##     num_iterations = integer(), min_data_in_leaf = integer(), 
##     max_depth = integer(), learning_rate = numeric(), min_gain_to_split = numeric(), 
##     verbose = -1, num_threads = 0, seed = sample.int(10^5, 1), 
##     deterministic = TRUE)
}\if{html}{\out{</div>}}

\code{\link[bonsai:train_lightgbm]{bonsai::train_lightgbm()}} is a wrapper
around \code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}} (and other
functions) that make it easier to run this model.
}

\subsection{Other details}{
\subsection{Preprocessing}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.

Non-numeric predictors (i.e., factors) are internally converted to
numeric. In the classification context, non-numeric outcomes (i.e.,
factors) are also internally converted to numeric.
}

\subsection{Interpreting \code{mtry}}{

The \code{mtry} argument denotes the number of predictors that will be
randomly sampled at each split when creating tree models.

Some engines, such as \code{"xgboost"}, \code{"xrf"}, and \code{"lightgbm"}, interpret
their analogue to the \code{mtry} argument as the \emph{proportion} of predictors
that will be randomly sampled at each split rather than the \emph{count}. In
some settings, such as when tuning over preprocessors that influence the
number of predictors, this parameterization is quite
helpful—interpreting \code{mtry} as a proportion means that \verb{[0, 1]} is
always a valid range for that parameter, regardless of input data.

parsnip and its extensions accommodate this parameterization using the
\code{counts} argument: a logical indicating whether \code{mtry} should be
interpreted as the number of predictors that will be randomly sampled at
each split. \code{TRUE} indicates that \code{mtry} will be interpreted in its
sense as a count, \code{FALSE} indicates that the argument will be
interpreted in its sense as a proportion.

\code{mtry} is a main model argument for
\code{\link[=boost_tree]{boost_tree()}} and
\code{\link[=rand_forest]{rand_forest()}}, and thus should not have an
engine-specific interface. So, regardless of engine, \code{counts} defaults
to \code{TRUE}. For engines that support the proportion interpretation
(currently \code{"xgboost"} and \code{"xrf"}, via the rules package, and
\code{"lightgbm"} via the bonsai package) the user can pass the
\code{counts = FALSE} argument to \code{set_engine()} to supply \code{mtry} values
within \verb{[0, 1]}.
}

}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("boost_tree_predict") |>
  dplyr::filter(engine == "lightgbm") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 4 x 2
##   mode           type   
##   <chr>          <chr>  
## 1 regression     numeric
## 2 classification class  
## 3 classification prob   
## 4 classification raw
}\if{html}{\out{</div>}}
\subsection{Bagging}{

The \code{sample_size} argument is translated to the \code{bagging_fraction}
parameter in the \code{param} argument of \code{lgb.train}. The argument is
interpreted by lightgbm as a \emph{proportion} rather than a count, so bonsai
internally reparameterizes the \code{sample_size} argument with
\code{\link[dials:trees]{dials::sample_prop()}} during tuning.

To effectively enable bagging, the user would also need to set the
\code{bagging_freq} argument to lightgbm. \code{bagging_freq} defaults to 0, which
means bagging is disabled, and a \code{bagging_freq} argument of \code{k} means
that the booster will perform bagging at every \code{k}th boosting iteration.
Thus, by default, the \code{sample_size} argument would be ignored without
setting this argument manually. Other boosting libraries, like xgboost,
do not have an analogous argument to \code{bagging_freq} and use \code{k = 1} when
the analogue to \code{bagging_fraction} is in $\verb{(0, 1)}$. \emph{bonsai will thus
automatically set} \code{bagging_freq = 1} \emph{in} \code{set_engine("lightgbm", ...)}
if \code{sample_size} (i.e. \code{bagging_fraction}) is not equal to 1 and no
\code{bagging_freq} value is supplied. This default can be overridden by
setting the \code{bagging_freq} argument to \code{set_engine()} manually.
}

\subsection{Verbosity}{

bonsai quiets much of the logging output from
\code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}} by default. With
default settings, logged warnings and errors will still be passed on to
the user. To print out all logs during training, set \code{quiet = TRUE}.
}

}

\subsection{Sparse Data}{

This model can utilize sparse data during model fitting and prediction.
Both sparse matrices such as dgCMatrix from the \code{Matrix} package and
sparse tibbles from the \code{sparsevctrs} package are supported. See
\link{sparse_data} for more information.
}

\subsection{Examples}{

The “Introduction to bonsai” article contains
\href{https://bonsai.tidymodels.org/articles/bonsai.html}{examples} of
\code{boost_tree()} with the \code{"lightgbm"} engine.
}

\subsection{References}{
\itemize{
\item \href{https://papers.nips.cc/paper/2017/hash/6449f44a102fde848669bdd9eb6b76fa-Abstract.html}{LightGBM: A Highly Efficient Gradient Boosting Decision Tree}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
