% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lmmfit.R
\name{summary.lmmfit}
\alias{summary.lmmfit}
\title{Extract model fits from step 1 of PRC-LMM}
\usage{
\method{summary}{lmmfit}(object, yname, what = "betas", ...)
}
\arguments{
\item{object}{the output of `fit_lmms`}

\item{yname}{a character giving the name of the longitudinal
variable for which you want to extract information}

\item{what}{one of the following: `'betas'` for the estimates 
of the regression coefficients; `'tTable'` for the usual T table
produced by `nlme`; `'variances'` for the estimates of 
the variances (and covariances) of the random effects and of the
variance of the error term}

\item{...}{additional arguments}
}
\value{
A vector containing the estimated fixed-effect parameters if 
`what = 'betas'`, the usual T table produced by `nlme` if `what = 'tTable'`,
or the estimated variance-covariance matrix of the random
effects and the estimated variance of the error if `what = 'variances'`
}
\description{
Summary function to extract the estimated fixed effect parameters and
variances of the random effects from an object fitted using `fit_lmms`
}
\references{
Signorelli, M. (2024). pencal: an R Package for the Dynamic 
Prediction of Survival with Many Longitudinal Predictors. 
The R Journal, 16 (2), 134-153.

Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine, 40 (27), 6178-6196.
}
\seealso{
\code{\link{fit_lmms}}
}
\author{
Mirko Signorelli
}
