% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wWHIT.R
\name{smooth_wWHIT}
\alias{smooth_wWHIT}
\title{Weigthed Whittaker Smoother}
\usage{
smooth_wWHIT(
  y,
  w,
  ylu,
  nptperyear,
  wFUN = wTSM,
  iters = 1,
  lambda = 15,
  second = FALSE,
  ...
)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{ylu}{\verb{[low, high]} of time-series y (curve fitting values are constrained
in the range of \code{ylu}.}

\item{nptperyear}{Integer, number of images per year.}

\item{wFUN}{weights updating function, can be one of 'wTSM', 'wChen' and
'wBisquare'.}

\item{iters}{How many times curve fitting is implemented.}

\item{lambda}{scaler or numeric vector, whittaker parameter.
\itemize{
\item If \code{lambda = NULL}, \code{V-curve} theory will be applied to retrieve the optimal \code{lambda}.
\item If multiple \code{lambda} provided (numeric vector), a list of the smoothing results
with the same length of \code{lambda} will be returned.
}}

\item{second}{If true, in every iteration, Whittaker will be implemented
twice to make sure curve fitting is smooth. If curve has been smoothed
enough, it will not care about the second smooth. If no, the second one is
just prepared for this situation. If lambda value has been optimized, second
smoothing is unnecessary.}

\item{...}{Additional parameters are passed to \code{wFUN}.}
}
\value{
\itemize{
\item \code{ws}: weights of every iteration
\item \code{zs}: curve fittings of every iteration
}
}
\description{
Weigthed Whittaker Smoother
}
\note{
Whittaker smoother of the second order difference is used!
}
\examples{
data("MOD13A1")
dt <- tidy_MOD13(MOD13A1$dt)
d <- dt[site == "AT-Neu", ]

l <- check_input(d$t, d$y, d$w, nptperyear=23)
r_wWHIT <- smooth_wWHIT(l$y, l$w, l$ylu, nptperyear = 23, iters = 2)

## Optimize `lambda` by V-curve theory
# (a) optimize manually
lambda_vcurve(l$y, l$w, plot = TRUE) 

# (b) optimize automatically by setting `lambda = NULL` in smooth_wWHIT
r_wWHIT2 <- smooth_wWHIT(l$y, l$w, l$ylu, nptperyear = 23, iters = 2, lambda = NULL) # 
}
\references{
\enumerate{
\item Eilers, P.H.C., 2003. A perfect smoother. Anal. Chem. \doi{10.1021/ac034173t}
\item Frasso, G., Eilers, P.H.C., 2015. L- and V-curves for optimal smoothing. Stat.
Modelling 15, 91-111. \doi{10.1177/1471082X14549288}.
}
}
\seealso{
\code{\link[=lambda_vcurve]{lambda_vcurve()}}
}
