% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_print_and_play.R
\name{save_print_and_play}
\alias{save_print_and_play}
\title{Save piecepack print-and-play (PnP) file}
\usage{
save_print_and_play(
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  output_filename = "piecepack.pdf",
  size = c("letter", "A4", "A5", "4x6"),
  pieces = NULL,
  arrangement = c("single-sided", "double-sided"),
  dev = NULL,
  dev.args = list(family = cfg$fontfamily, onefile = TRUE, units = "in", bg = "white",
    res = 300),
  quietly = FALSE,
  ...,
  bleed = FALSE,
  size_bleed = NULL
)
}
\arguments{
\item{cfg}{Piecepack configuration list or \code{pp_cfg} object}

\item{output_filename}{Filename for print-and-play file}

\item{size}{PnP output size (currently supports either "letter", "A4", "A5", or "4x6").
This is the targeted \dQuote{trim} size of the print-and-play file
(\code{size_bleed} can be used to make the print-and-play file larger than this).
Size "4x6" currently only supports \code{pieces = "piecepack"}
and doesn't support \code{bleed = TRUE}.
"A5" is in \dQuote{portrait} mode whereas the other sizes are in \dQuote{landscape} mode.}

\item{pieces}{Character vector of desired PnP pieces.
Supports "piecepack", "matchsticks", "pyramids", "subpack", or "all".
If \code{NULL} and combination of \code{size} / \code{bleed} values supports "matchsticks" and "pyramids"
then defaults to \code{c("piecepack", "pyramids", "matchsticks")} else just "piecepack".}

\item{arrangement}{Either "single-sided" or "double-sided".
Ignored if \code{size = "4x6"}.}

\item{dev}{Graphics device function to use if \code{open_device} is \code{FALSE}.
If \code{NULL} infer a reasonable choice from \code{file}.}

\item{dev.args}{Additional arguments to pass to \code{dev} (besides \code{filename}, \code{width}, and \code{height}).
Will filter out any names that aren't in \code{formals(dev)}.}

\item{quietly}{Whether to hide messages about missing metadata
in the provided configuration.}

\item{...}{Currently ignored.}

\item{bleed}{If \code{TRUE} produce a variant print-and-play file with "bleed" zones
and "crop marks" around game pieces.
Currently only supports \code{pieces = "piecepack"} and doesn't
support \code{size = "4x6"}.}

\item{size_bleed}{A list with names "top", "right", "bottom", "left"
containing numeric values indicating the inches "bleed" to add to
the \code{size} of the print-and-play layout.
The default \code{NULL} means no such bleed added to "letter", "A4", "A5"
layouts and a small bleed added to "4x6" layouts
(1/16" to top/bottom and 3/32" to left/right).
NB. multiply millimeters by \code{0.0393700787} to convert to inches.
We currently don't support an asymmetric left/right bleed combined with
\code{arrangement = "double-sided"}.}
}
\description{
Save piecepack print-and-play (PnP) file
}
\examples{
\donttest{# May take more than 5 seconds on CRAN servers
if (capabilities("cairo")) {
  cfg <- pp_cfg(list(invert_colors.suited=TRUE))
  cfg$description <- 'Piecepack with an "inverted" color scheme.'
  cfg$title <- '"Inverted" piecepack'
  cfg$copyright <- "\u00a9 2022 Trevor L Davis.  Some Right Reserved."
  cfg$spdx_id <- "CC-BY-4.0"
  cfg$credit <- ""

  file <- tempfile("my_pnp_file", fileext = ".pdf")
  file_ds <- tempfile("my_pnp_file_ds", fileext = ".pdf")
  file_a4 <- tempfile("my_pnp_file_a4", fileext = ".pdf")
  file_a5 <- tempfile("my_pnp_file_a5", fileext = ".pdf")

  save_print_and_play(cfg, file)
  save_print_and_play(cfg, file_ds, arrangement="double-sided")
  save_print_and_play(cfg, file_a4, size="A4", pieces="all")
  save_print_and_play(cfg, file_a5, size="A5")
}
}
}
