% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aabb_piece.R
\name{aabb_piece}
\alias{aabb_piece}
\title{Calculate axis-aligned bounding box for set of game pieces}
\usage{
aabb_piece(
  df,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  envir = getOption("piecepackr.envir"),
  op_scale = getOption("piecepackr.op_scale", 0),
  op_angle = getOption("piecepackr.op_angle", 45),
  ...
)
}
\arguments{
\item{df}{A data frame of game piece information with (at least) the
named columns \dQuote{piece_side}, \dQuote{x}, and \dQuote{y}.}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{op_scale}{How much to scale the depth of the piece in the oblique projection
(viewed from the top of the board).
\code{0} (the default) leads to an \dQuote{orthographic} projection,
\code{0.5} is the most common scale used in the \dQuote{cabinet} projection,
and \code{1.0} is the scale used in the \dQuote{cavalier} projection.}

\item{op_angle}{What is the angle of the oblique projection?  Has no effect if \code{op_scale} is \code{0}.}

\item{...}{Ignored}
}
\value{
A named list of ranges with five named elements \code{x}, \code{y}, and \code{z} for
the axis-aligned bounding cube
in xyz-space plus \code{x_op} and \code{y_op} for the axis-aligned bounding box
of the \dQuote{oblique projection} onto the xy plane.
}
\description{
Calculate axis-aligned bounding box (AABB) for set of game pieces
with and without an \dQuote{oblique projection}.
}
\details{
The \dQuote{oblique projection} of a set of \eqn{(x,y,z)} points onto the xy-plane
is \eqn{(x + \lambda * z * cos(\alpha), y + \lambda * z * sin(\alpha))}
where \eqn{\lambda} is the scale factor and \eqn{\alpha} is the angle.
}
\examples{
 df_tiles <- data.frame(piece_side="tile_back", x=0.5+c(3,1,3,1), y=0.5+c(3,3,1,1),
                        suit=NA, angle=NA, z=NA, stringsAsFactors=FALSE)
 df_coins <- data.frame(piece_side="coin_back", x=rep(4:1, 4), y=rep(4:1, each=4),
                        suit=1:16\%\%2+rep(c(1,3), each=8),
                        angle=rep(c(180,0), each=8), z=1/4+1/16, stringsAsFactors=FALSE)
 df <- rbind(df_tiles, df_coins)

 aabb_piece(df, op_scale = 0)
 aabb_piece(df, op_scale = 1, op_angle = 45)
 aabb_piece(df, op_scale = 1, op_angle = -90)
}
