% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_run.R
\name{api_run}
\alias{api_run}
\alias{api_stop}
\title{Launch the API}
\usage{
api_run(
  api,
  host = NULL,
  port = NULL,
  block = !is_interactive(),
  showcase = is_interactive(),
  ...,
  silent = FALSE
)

api_stop(api)
}
\arguments{
\item{api}{A plumber2 api object to launch or stop}

\item{host, port}{Host and port to run the api on. If not provided the host
and port used during the creation of the Plumber2 api will be used}

\item{block}{Should the console be blocked while running (alternative is
to run in the background). Defaults to \code{FALSE} in interactive sessions and
\code{TRUE} otherwise.}

\item{showcase}{Should the default browser open up at the server address.
If \code{TRUE} then a browser opens at the root of the api, unless the api
contains OpenAPI documentation in which case it will open at that
location. If a string the string is used as a path to add to the root
before opening.}

\item{...}{Arguments passed on to the \code{start} handler}

\item{silent}{Should startup messaging by silenced}
}
\value{
These functions return the \code{api} object allowing for easy chaining
with the pipe, even though they will often be the last part of the chain
}
\description{
This function starts the api with the settings it has defined.
}
\examples{
pa <- api() |>
  api_get("/", function() {
    list(msg = "Hello World")
  }) |>
  api_on("start", function(...) {
    cat("I'm alive")
  })

# Start the server
pa |> api_run(block = FALSE)

# Stop it again
pa |> api_stop()

}
