% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhs_data_funs.R
\name{rhs_plot_mlx}
\alias{rhs_plot_mlx}
\title{Generate Right-hand side data plot (Monolix)}
\usage{
rhs_plot_mlx(
  rhs,
  x_var,
  inputs,
  est_parms = NULL,
  mlx_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{x_var}{(string) Name of the variable in inputs against which the right-hand data should be plotted.}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{mlx_file}{(string; semi-optional) (path)/name of the Monolix run. Must include ".mlxtran" and estimation bust have been run previously. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
ggplot of right-hand side data.
}
\description{
This functions allows to generate right-hand side plot, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{mlx_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
mlx_path <- system.file("extdata","mlx_example1_ind.mlxtran",package="pmxNODE")
est_parms <- pre_fixef_extractor_mlx(mlx_path)
rhs_plot <- rhs_plot_mlx(rhs="NNc + WT * NNct",
                         x_var = "NNc",
                         inputs = data.frame(NNc = 1:100,
                                             NNct = seq(0,10,length.out=100),
                                             WT = rep(50,100)),
                         est_parms=est_parms,
                         time_nn = c(FALSE, TRUE))
}
\author{
Dominic Bräm
}
