% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_tree-plot.R
\name{plot.policy_tree}
\alias{plot.policy_tree}
\title{Plot a policy_tree tree object.}
\usage{
\method{plot}{policy_tree}(x, leaf.labels = NULL, ...)
}
\arguments{
\item{x}{The tree to plot.}

\item{leaf.labels}{An optional character vector of leaf labels for each treatment.}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Plot a policy_tree tree object.
}
\examples{
# Plot a policy_tree object
\dontrun{
n <- 250
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- as.factor(sample(c("A", "B", "C"), n, replace = TRUE))
Y <- X[, 1] + X[, 2] * (W == "B") + X[, 3] * (W == "C") + runif(n)
multi.forest <- grf::multi_arm_causal_forest(X = X, Y = Y, W = W)
Gamma.matrix <- double_robust_scores(multi.forest)
tree <- policy_tree(X, Gamma.matrix, depth = 2)
plot(tree)

# Provide optional names for the treatment names in each leaf node
# `action.names` is by default the column names of the reward matrix
plot(tree, leaf.labels = tree$action.names)
# Providing a custom character vector
plot(tree, leaf.labels = c("treatment A", "treatment B", "placebo C"))

# Saving a plot in a vectorized SVG format can be done with the `DiagrammeRsvg` package.
install.packages("DiagrammeRsvg")
tree.plot = plot(tree)
cat(DiagrammeRsvg::export_svg(tree.plot), file = 'plot.svg')
}
}
