% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moeTopline.R
\name{moe_topline}
\alias{moe_topline}
\title{weighted topline with margin of error}
\usage{
moe_topline(
  df,
  variable,
  weight,
  remove = c(""),
  n = TRUE,
  pct = TRUE,
  valid_pct = TRUE,
  cum_pct = TRUE,
  zscore = 1.96
)
}
\arguments{
\item{df}{The data source}

\item{variable}{the variable name}

\item{weight}{The weighting variable, defaults to zwave_weight}

\item{remove}{An optional character vector of values to remove from final table (e.g. "refused").
This will not affect any calculations made. The vector is not case-sensitive.}

\item{n}{logical, if TRUE a frequency column is included
percentages, but in a separate row for column percentages.}

\item{pct}{logical, if TRUE a column of percents is included}

\item{valid_pct}{logical, if TRUE a column of valid percents is included}

\item{cum_pct}{logical, if TRUE a column of cumulative percents is included}

\item{zscore}{defaults to 1.96, consistent with a 95\% confidence interval}
}
\value{
a tibble
}
\description{
\code{moe_topline} returns a tibble containing a weighted topline of one variable with margin of error
}
\details{
By default the table includes a column for frequency count, percent, valid percent, and cumulative percent.
}
\examples{
moe_topline(df = illinois, variable = educ6, weight = weight)
moe_topline(df = illinois, variable = educ6, weight = weight, remove = c("LT HS"))
}
