% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_conditional_indirect_effects.R
\name{test_cond_indirect_effects}
\alias{test_cond_indirect_effects}
\title{Test Several Conditional Indirect Effects}
\usage{
test_cond_indirect_effects(
  fit = fit,
  x = NULL,
  m = NULL,
  y = NULL,
  wlevels = NULL,
  mc_ci = TRUE,
  mc_out = NULL,
  boot_ci = FALSE,
  boot_out = NULL,
  check_post_check = TRUE,
  ...,
  fit_name = "fit",
  get_map_names = FALSE,
  get_test_name = FALSE
)
}
\arguments{
\item{fit}{The fit object, to be
passed to \code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}}.}

\item{x}{The name of the \code{x}-variable,
the predictor.}

\item{m}{A character vector of the
name(s) of mediator(s). The path
moves from the first mediator in the
vector to the last mediator in the
vector. Can be \code{NULL} and the path
is a direct path without mediator.}

\item{y}{The name of the \code{y}-variable,
the outcome variable.}

\item{wlevels}{The output of
\code{\link[manymome:merge_mod_levels]{manymome::merge_mod_levels()}}, or
the moderator(s) to be passed to
\code{\link[manymome:mod_levels]{manymome::mod_levels_list()}}.
If all the moderators can be
represented by one variable, that is,
each moderator is (a) a numeric
variable, (b) a dichotomous
categorical variable, or (c) a
factor or string variable used in
\code{\link[stats:lm]{stats::lm()}} in fit, then it is a
vector of the names of the moderators
as appeared in the data frame. If at
least one of the moderators is a
categorical variable represented by
more than one variable, such as
user-created dummy variables used in
\code{\link[lavaan:sem]{lavaan::sem()}}, then it must be a
list of the names of the moderators,
with such moderators represented by
a vector of names. For example:
\verb{list("w1", c("gpgp2", "gpgp3")},
the first moderator \code{w1} and the
second moderator a three-category
variable represented by \code{gpgp2} and
\code{gpgp3}. See the help page of
\code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}}
for further details.}

\item{mc_ci}{Logical. If \code{TRUE}, the
default, Monte Carlo confidence
intervals will be formed. This argument
and \code{boot_ci} cannot be both \code{TRUE}.}

\item{mc_out}{The pre-generated
Monte Carlo estimates generated by
\link[manymome:do_mc]{manymome::do_mc}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{boot_ci}{Logical. If \code{TRUE},
the default, nonparametric bootstrap
confidence intervals will be formed.
This argument
and \code{mc_ci} cannot be both \code{TRUE}.}

\item{boot_out}{The pre-generated
bootstrap estimates generated by
\link[manymome:do_boot]{manymome::do_boot}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{check_post_check}{Logical. If
\code{TRUE}, the default, and the model
is fitted by \code{lavaan}, the test
will be conducted only if the model
passes the \code{post.check} conducted
by \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} (with
\code{what = "post.check"}).}

\item{...}{Additional arguments to
be passed to \code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}}.}

\item{fit_name}{The name of the
model fit object to be extracted.
Default is \code{"fit"}. Used only when
more than one model is fitted in
each replication. This should be
the name of the model on which the
test is to be conducted.}

\item{get_map_names}{Logical. Used
by \code{\link[=power4test]{power4test()}} to determine how
to extract stored information and
assign them to this function. Users
should not use this argument.}

\item{get_test_name}{Logical. Used
by \code{\link[=power4test]{power4test()}} to get the default
name of this test. Users should not
use this argument.}
}
\value{
In its normal usage, it returns
the output returned by
\code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}},
with the following modifications:
\itemize{
\item \code{est}: The estimated
conditional indirect effects.
\item \code{cilo} and \code{cihi}: The
lower and upper limits of the
confidence interval (95\% by
default), respectively.
\item \code{sig}: Whether a test by confidence
interval is significant (\code{1}) or
not significant (\code{0}).
\item \code{test_label}: A column of labels
generated to label the conditional
effects.
}
}
\description{
Test several conditional
indirect effects
for a \code{power4test} object.
}
\details{
This function is to be used in
\code{\link[=power4test]{power4test()}} for testing several
conditional
indirect effects, by setting it
to the \code{test_fun} argument.

It uses \code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}}
to do the test. It can be used on
models fitted by \code{\link[lavaan:sem]{lavaan::sem()}}
or fitted by a sequence of calls
to \code{\link[stats:lm]{stats::lm()}}, although only
nonparametric bootstrap confidence
interval is supported for models
fitted by regression using
\code{\link[stats:lm]{stats::lm()}}.

It can also be used to test
conditional effects on a direct path
with no mediator. Just omit \code{m} when
calling the function.
}
\examples{

# Specify the model

model_simple_mod <-
"
m ~ x + w + x:w
y ~ m + x
"

# Specify the population values

model_simple_mod_es <-
"
y ~ m: l
y ~ x: n
m ~ x: m
m ~ w: n
m ~ x:w: l
"

# Simulate the data

# Set nrep to a larger value in real analysis, such as 400
sim_only <- power4test(nrep = 5,
                       model = model_simple_mod,
                       pop_es = model_simple_mod_es,
                       n = 100,
                       R = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the tests in each replication

test_out <- power4test(object = sim_only,
                       test_fun = test_cond_indirect_effects,
                       test_args = list(x = "x",
                                        m = "m",
                                        y = "y",
                                        wlevels = c("w"),
                                        mc_ci = TRUE))
print(test_out,
      test_long = TRUE)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
