rpweibull <-
function (n = 1, rate = 1, alpha = 1, t = 0) 
{
    if (length(t) != length(rate)) 
        stop("length of t must be equal to length of rate")
    if (length(t) != length(alpha)) 
        stop("length of t must be equal to length of alpha")
    if (!isTRUE(all.equal(0, t[1]))) 
        stop("first element of t should be 0")
    if (any(alpha<0)) 
        stop("alpha's should be positive values")
    if (is.unsorted(t)) 
        stop("t should be in increasing order")
if (n == 0) 
        return(numeric(0))
    if (length(n) > 1) 
        n <- length(n)
u <- runif(n)
qpweibull(u, rate=rate, alpha=alpha, t=t)
}
