% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projoint_level.R
\name{projoint_level}
\alias{projoint_level}
\title{Estimate profile- or choice-level effects (internal)}
\usage{
projoint_level(
  .data,
  .qoi,
  .structure,
  .estimand,
  .se_method,
  .irr,
  .remove_ties,
  .ignore_position,
  .n_sims,
  .n_boot,
  .weights_1,
  .clusters_1,
  .se_type_1,
  .weights_2,
  .clusters_2,
  .se_type_2,
  .auto_cluster = TRUE,
  .seed = NULL
)
}
\arguments{
\item{.data}{A \code{\link{projoint_data}} object.}

\item{.qoi}{Optional \code{\link{projoint_qoi}}; if \code{NULL}, estimates all
MMs/AMCEs implied by the design. When supplied, overrides \code{.structure}
and \code{.estimand}.}

\item{.structure}{Either \code{"profile_level"} or \code{"choice_level"}.}

\item{.estimand}{Either \code{"mm"} (marginal mean) or \code{"amce"} (average
marginal component effect).}

\item{.se_method}{One of \code{"analytical"}, \code{"simulation"}, or
\code{"bootstrap"}.}

\item{.irr}{\code{NULL} to estimate IRR from repeated tasks; numeric to fix IRR.}

\item{.remove_ties}{Logical; whether to drop tied responses (default \code{TRUE}).}

\item{.ignore_position}{Logical; choice-level only. Ignore left/right position?
Default \code{TRUE}.}

\item{.n_sims}{Integer; required when \code{.se_method = "simulation"}.}

\item{.n_boot}{Integer; required when \code{.se_method = "bootstrap"}.}

\item{.weights_1, .clusters_1, .se_type_1}{Arguments passed to
\code{\link[estimatr]{lm_robust}} for IRR estimation. If \code{.se_type_1}
is \code{NULL}, \emph{estimatr} defaults are used.}

\item{.weights_2, .clusters_2, .se_type_2}{Arguments passed to
\code{\link[estimatr]{lm_robust}} for MM/AMCE estimation. If \code{.se_type_2}
is \code{NULL}, \emph{estimatr} defaults are used.}

\item{.auto_cluster}{Logical; if \code{TRUE} (default) and an \code{id} column
is present while no clusters are provided, cluster automatically. Only applied
when the corresponding \code{.se_type_*} is \code{NULL}.}

\item{.seed}{Optional integer; if supplied, sets a temporary RNG seed for
simulation/bootstrap and restores prior state on exit.}
}
\value{
A \code{\link{projoint_results}} object containing:
\itemize{
  \item \code{estimates}: tibble of estimates (point estimate, SE, CI) with
        identifier columns (e.g., \code{att_level_*}).
  \item \code{estimand}: \code{"mm"} or \code{"amce"}.
  \item \code{structure}: \code{"profile_level"} or \code{"choice_level"}.
  \item \code{se_method}: SE computation method used.
  \item \code{irr}: character noting IRR usage (e.g., \code{"Estimated"} or
        \code{"Assumed (<value> )"}).
  \item \code{tau}: numeric \eqn{\tau} used to correct measurement error.
  \item \code{remove_ties}, \code{ignore_position}: flags echoed from inputs.
  \item \code{se_type_used}, \code{cluster_by}: details propagated from
        fitting calls (if available).
  \item \code{labels}, \code{data}: design labels and the analysis data
        passed through for downstream methods.
}
}
\description{
Core worker used by \code{\link{projoint}} to compute marginal means (MMs)
or average marginal component effects (AMCEs) under either the profile- or
choice-level structure. Handles IRR usage (estimated or fixed) and the
requested standard-error method.
}
\seealso{
\code{\link{projoint}}, \code{\link{pj_estimate}}, \code{\link{organize_data}},
  \code{\link{projoint_results}}
}
\keyword{internal}
