% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teeMod.R
\name{estfun.teeMod}
\alias{estfun.teeMod}
\title{Extract empirical estimating equations from a \code{teeMod} model fit}
\usage{
\method{estfun}{teeMod}(x, ...)
}
\arguments{
\item{x}{a fitted \code{teeMod} model}

\item{...}{arguments passed to methods, most importantly those that define
the bias corrections for the residuals of \code{x} and, if applicable, a
\code{fitted_covariance_model} stored in its offset}
}
\value{
An \eqn{n\times k} matrix of empirical estimating equations for \code{x}.
\code{k} includes the model intercept, main effects of treatment and
moderator variables, any moderator effects, and marginal and conditional
means of the outcome (and \code{offset}, if provided) in the control condition.
See Details for definition of \eqn{n}.
}
\description{
An S3method for \code{sandwich::estfun} for producing a matrix
of contributions to the direct adjustment estimating equations.
}
\details{
If a prior covariance adjustment model has been passed to the
\code{offset} argument of the \code{teeMod} model using \code{cov_adj()},
\code{estfun.teeMod()} incorporates contributions to the estimating
equations of the covariance adjustment model.\cr\cr The covariance
adjustment sample may not fully overlap with the direct adjustment sample,
in which case \code{estfun.teeMod()} returns a matrix with the same number
of rows as the number of unique units of observation used to fit the two
models. Uniqueness is determined by matching units of assignment used to
fit the covariance adjustment model to units of assignment in the
\code{teeMod} model's \code{StudySpecification} slot; units of observation
within units of assignment that do not match are additional units that add
to the row count.\cr\cr The\code{by} argument in \code{cov_adj()} can
provide a column or a pair of columns (a named vector where the name
specifies a column in the direct adjustment sample and the value a column
in the covariance adjustment sample) that uniquely specifies units of
observation in each sample. This information can be used to align each
unit of observation's contributions to the two sets of estimating
equations. If no \code{by} argument is provided and units of observation
cannot be uniquely specified, contributions are aligned up to the unit of
assignment level. If standard errors are clustered no finer than that,
they will provide the same result as if each unit of observation's
contributions were aligned exactly.\cr\cr This method incorporates bias
corrections made to the residuals of \code{x} and, if applicable, the
covariance model stored in its \code{offset}. When its crossproduct is taken
(perhaps after suitable summing across rows within clusters), it provides
a heteroskedasticity- (or cluster-) robust estimate of the meat matrix of
the variance-covariance of the parameter estimates in \code{x}.
}
